/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class PairTest
extends IndusTestCase {
    private Pair pair1;
    private Pair pair2;

    public final void testGetFirst() {
        PairTest.assertTrue((boolean)this.pair1.getFirst().equals("first"));
    }

    public final void testGetSecond() {
        PairTest.assertTrue((boolean)this.pair1.getSecond().equals("second"));
    }

    public final void testHashCodeAndEquals() {
        Pair pair = new Pair("first", "second");
        PairTest.assertTrue((this.pair1.hashCode() != this.pair2.hashCode() ? 1 : 0) != 0);
        PairTest.assertTrue((this.pair1.hashCode() == pair.hashCode() ? 1 : 0) != 0);
        PairTest.assertFalse((boolean)this.pair1.equals(this.pair2));
        PairTest.assertTrue((boolean)this.pair1.equals(pair));
        Pair pair2 = new Pair(null, null);
        Pair pair3 = new Pair(null, null);
        PairTest.assertTrue((boolean)pair2.equals(pair3));
        PairTest.assertTrue((pair2.hashCode() == pair3.hashCode() ? 1 : 0) != 0);
        PairTest.assertFalse((boolean)pair2.equals("hi"));
    }

    public final void testMapify() {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        arrayList.add(this.pair1);
        arrayList.add(this.pair2);
        Map map = Pair.mapify(arrayList, true);
        Collection collection = (Collection)map.get(this.pair1.getFirst());
        PairTest.assertTrue((collection.size() == 1 ? 1 : 0) != 0);
        PairTest.assertTrue((boolean)collection.contains(this.pair1.getSecond()));
        Collection collection2 = (Collection)map.get(this.pair2.getFirst());
        PairTest.assertTrue((collection2.size() == 1 ? 1 : 0) != 0);
        PairTest.assertTrue((boolean)collection2.contains(this.pair2.getSecond()));
        Pair pair = new Pair("first", "fifth");
        arrayList.add(pair);
        map = Pair.mapify(arrayList, true);
        PairTest.assertTrue((boolean)(map.get(this.pair1.getFirst()) instanceof Collection));
        PairTest.assertTrue((boolean)((Collection)map.get(this.pair1.getFirst())).contains(pair.getSecond()));
        PairTest.assertTrue((boolean)((Collection)map.get(this.pair1.getFirst())).contains(this.pair1.getSecond()));
        map = Pair.mapify(arrayList, false);
        PairTest.assertTrue((boolean)((Collection)map.get(this.pair1.getSecond())).contains(this.pair1.getFirst()));
        PairTest.assertTrue((boolean)((Collection)map.get(pair.getSecond())).contains(pair.getFirst()));
        PairTest.assertTrue((boolean)((Collection)map.get(this.pair2.getSecond())).contains(this.pair2.getFirst()));
        PairTest.assertTrue((boolean)Pair.mapify(Collections.EMPTY_LIST, true).isEmpty());
    }

    public final void testOptimizeAndUnoptimize1() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("first");
        Pair pair = new Pair("first", arrayList);
        int n = pair.hashCode();
        arrayList.add("second");
        PairTest.assertTrue((pair.hashCode() == n ? 1 : 0) != 0);
        pair.unoptimize();
        PairTest.assertTrue((pair.hashCode() != n ? 1 : 0) != 0);
        pair.optimize();
        PairTest.assertTrue((pair.hashCode() != n ? 1 : 0) != 0);
    }

    public final void testOptimizeAndUnoptimize2() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("first");
        Pair pair = new Pair("first", stringBuffer);
        int n = pair.hashCode();
        stringBuffer.append("second");
        PairTest.assertTrue((pair.hashCode() == n ? 1 : 0) != 0);
        pair.unoptimize();
        PairTest.assertTrue((pair.hashCode() == n ? 1 : 0) != 0);
        pair.optimize();
        PairTest.assertTrue((pair.hashCode() == n ? 1 : 0) != 0);
    }

    public final void testPairManager() {
        Pair.PairManager pairManager = new Pair.PairManager();
        Pair pair = pairManager.getOptimizedPair("first", "second");
        Pair pair2 = pairManager.getOptimizedPair("first", "second");
        Pair pair3 = pairManager.getUnOptimizedPair("first", "second");
        Pair pair4 = pairManager.getUnOptimizedPair("first", "second");
        PairTest.assertTrue((pair == pair2 ? 1 : 0) != 0);
        PairTest.assertTrue((pair3 == pair4 ? 1 : 0) != 0);
        PairTest.assertTrue((pair == pair3 ? 1 : 0) != 0);
        pairManager.reset();
        Pair pair5 = pairManager.getUnOptimizedPair("first", "second");
        PairTest.assertTrue((pair != pair5 ? 1 : 0) != 0);
    }

    public final void testToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(true);
        Pair pair = new Pair("first", stringBuffer);
        pair.optimize();
        String string = pair.toString();
        pair.unoptimize();
        stringBuffer.append(false);
        String string2 = pair.toString();
        PairTest.assertFalse((boolean)string.equals(string2));
        pair.optimize();
        String string3 = pair.toString();
        PairTest.assertFalse((boolean)string.equals(string3));
        PairTest.assertTrue((boolean)string2.equals(string3));
    }

    protected void setUp() throws Exception {
        this.pair1 = new Pair("first", "second");
        this.pair2 = new Pair("third", "fourth");
    }

    protected void tearDown() throws Exception {
        this.pair1 = null;
        this.pair2 = null;
    }
}

