/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Pair {
    protected Object first;
    protected Object second;
    private String str;
    private int hashCode;

    public Pair(Object object, Object object2, boolean bl) {
        this.first = object;
        this.second = object2;
        if (bl) {
            this.optimize();
        }
    }

    public Pair(Object object, Object object2) {
        this(object, object2, true);
    }

    public Object getFirst() {
        return this.first;
    }

    public Object getSecond() {
        return this.second;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Pair) {
            Pair pair = (Pair)object;
            bl = this.first == null ? this.first == pair.first : this.first.equals(pair.first);
            if (bl) {
                bl = this.second == null ? this.second == pair.second : this.second.equals(pair.second);
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.str == null ? this.hash() : this.hashCode;
        return n;
    }

    public static Map mapify(Collection collection, boolean bl) {
        Map<Object, ArrayList<Object>> map = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Pair pair = (Pair)iterator.next();
            if (bl) {
                object2 = pair.getFirst();
                object = pair.getSecond();
            } else {
                object2 = pair.getSecond();
                object = pair.getFirst();
            }
            ArrayList<Object> arrayList = (ArrayList<Object>)map.get(object2);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                map.put(object2, arrayList);
            }
            arrayList.add(object);
        }
        if (map.isEmpty()) {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public void optimize() {
        this.hashCode = this.hash();
        this.str = this.stringize();
    }

    public String toString() {
        String string = this.str == null ? this.stringize() : this.str;
        return string;
    }

    public void unoptimize() {
        this.str = null;
    }

    protected int hash() {
        int n = 17;
        if (this.first != null) {
            n = 37 * n + this.first.hashCode();
        }
        if (this.second != null) {
            n = 37 * n + this.second.hashCode();
        }
        return n;
    }

    protected String stringize() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public static final class PairManager {
        public static final String ID = "Pair management service";
        private final List pairs = new ArrayList();
        private final Pair pairCache = new Pair(null, null, false);

        public Pair getOptimizedPair(Object object, Object object2) {
            return this.getPair(object, object2, true);
        }

        public Pair getUnOptimizedPair(Object object, Object object2) {
            return this.getPair(object, object2, false);
        }

        public void reset() {
            this.pairs.clear();
        }

        private Pair getPair(Object object, Object object2, boolean bl) {
            Pair pair;
            this.pairCache.first = object;
            this.pairCache.second = object2;
            if (this.pairs.contains(this.pairCache)) {
                pair = (Pair)this.pairs.get(this.pairs.indexOf(this.pairCache));
            } else {
                pair = new Pair(object, object2, bl);
                this.pairs.add(0, pair);
            }
            return pair;
        }
    }
}

