/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.FastUnionFindElement;

public final class FastUnionFindElementTest
extends IndusTestCase {
    private FastUnionFindElement f1;
    private FastUnionFindElement f2;

    public void testFindAndUnion() {
        FastUnionFindElementTest.assertTrue((boolean)this.f1.find().equals(this.f1));
        FastUnionFindElementTest.assertTrue((boolean)this.f2.find().equals(this.f2));
        this.f1.union(this.f2);
        FastUnionFindElement fastUnionFindElement = this.f1.find();
        FastUnionFindElement fastUnionFindElement2 = this.f2.find();
        FastUnionFindElementTest.assertTrue((boolean)fastUnionFindElement.equals(fastUnionFindElement2));
        FastUnionFindElementTest.assertTrue((fastUnionFindElement.equals(this.f1) || fastUnionFindElement.equals(this.f2) ? 1 : 0) != 0);
        FastUnionFindElement fastUnionFindElement3 = new FastUnionFindElement();
        FastUnionFindElement fastUnionFindElement4 = new FastUnionFindElement();
        fastUnionFindElement3.setType("1");
        fastUnionFindElement4.union(fastUnionFindElement3);
        FastUnionFindElementTest.assertTrue((boolean)fastUnionFindElement4.find().equals(fastUnionFindElement3));
    }

    public void testGetTypeAndSetType() {
        Object object = new Object();
        this.f1.setType(object);
        FastUnionFindElementTest.assertTrue((boolean)object.equals(this.f1.getType()));
        try {
            this.f1.setType(object);
            FastUnionFindElementTest.fail((String)"This is incorrect.");
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    public void testIsAtomic() {
        FastUnionFindElementTest.assertTrue((boolean)this.f1.isAtomic());
        this.f1.addChild(this.f2);
        FastUnionFindElementTest.assertFalse((boolean)this.f1.isAtomic());
    }

    public void testIsBound() {
        FastUnionFindElementTest.assertFalse((boolean)this.f1.isBound());
        FastUnionFindElementTest.assertFalse((boolean)this.f2.isBound());
        this.f2.union(this.f1);
        this.f1.setType(new Object());
        FastUnionFindElementTest.assertTrue((boolean)this.f1.isBound());
        FastUnionFindElementTest.assertTrue((boolean)this.f2.isBound());
    }

    public void testSameType() {
        this.f1.setType(new Object());
        Object object = new Object();
        this.f2.setType(object);
        FastUnionFindElementTest.assertFalse((boolean)this.f1.sameType(this.f2));
        FastUnionFindElement fastUnionFindElement = new FastUnionFindElement();
        fastUnionFindElement.setType(object);
        FastUnionFindElementTest.assertTrue((boolean)this.f2.sameType(fastUnionFindElement));
    }

    public void testUnify1() {
        FastUnionFindElementTest.assertTrue((boolean)this.f1.unify(this.f2));
        this.f1.union(this.f2);
        FastUnionFindElementTest.assertTrue((boolean)this.f1.unify(this.f2));
    }

    public void testUnify2() {
        FastUnionFindElement fastUnionFindElement = new FastUnionFindElement();
        FastUnionFindElement fastUnionFindElement2 = new FastUnionFindElement();
        fastUnionFindElement.setType(new Object());
        fastUnionFindElement2.setType(new Object());
        FastUnionFindElementTest.assertFalse((boolean)fastUnionFindElement.unify(fastUnionFindElement2));
        this.f1.addChild(fastUnionFindElement);
        this.f2.addChild(fastUnionFindElement2);
        FastUnionFindElementTest.assertFalse((boolean)this.f1.unify(this.f2));
    }

    public void testUnifyChildren() {
        FastUnionFindElementTest.assertFalse((boolean)this.f1.unifyChildren(this.f2));
        FastUnionFindElement fastUnionFindElement = new FastUnionFindElement();
        FastUnionFindElement fastUnionFindElement2 = new FastUnionFindElement();
        this.f1.addChild(fastUnionFindElement);
        this.f2.addChild(fastUnionFindElement2);
        FastUnionFindElementTest.assertTrue((boolean)this.f1.unifyChildren(this.f2));
        FastUnionFindElement fastUnionFindElement3 = new FastUnionFindElement();
        FastUnionFindElement fastUnionFindElement4 = new FastUnionFindElement();
        fastUnionFindElement3.setType("1");
        fastUnionFindElement4.setType("2");
        this.f1.addChild(fastUnionFindElement3);
        this.f2.addChild(fastUnionFindElement4);
        FastUnionFindElementTest.assertFalse((boolean)this.f1.unifyChildren(this.f2));
    }

    protected void setUp() throws Exception {
        this.f1 = new FastUnionFindElement();
        this.f2 = new FastUnionFindElement();
    }

    protected void tearDown() throws Exception {
        this.f1 = null;
        this.f2 = null;
    }
}

