/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractWorkBagTest
extends IndusTestCase {
    protected IWorkBag wb;

    public void testAddAllWork() {
        List list = this.getWorkPieces();
        this.wb.addAllWork(list);
        while (this.wb.hasWork()) {
            AbstractWorkBagTest.assertTrue((boolean)list.contains(this.wb.getWork()));
        }
    }

    public void testAddAllWorkNoDuplicates() {
        List list = this.getWorkPieces();
        this.wb.addAllWork(list);
        ArrayList<Object> arrayList = new ArrayList<Object>(list.subList(2, 5));
        arrayList.add(new Object());
        Collection collection = this.wb.addAllWorkNoDuplicates(arrayList);
        AbstractWorkBagTest.assertTrue((boolean)arrayList.containsAll(collection));
        AbstractWorkBagTest.assertTrue((!collection.containsAll(arrayList) ? 1 : 0) != 0);
    }

    public void testAddWorkNoDuplicates() {
        List list = this.getWorkPieces();
        this.wb.addAllWork(list);
        AbstractWorkBagTest.assertFalse((boolean)this.wb.addWorkNoDuplicates(list.get(0)));
        AbstractWorkBagTest.assertTrue((boolean)this.wb.addWorkNoDuplicates(new Object()));
    }

    public final void testClear() {
        this.wb.clear();
        AbstractWorkBagTest.assertFalse((boolean)this.wb.hasWork());
        try {
            this.wb.getWork();
            AbstractWorkBagTest.fail((String)"This is incorrect behavior.");
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    public void testGetWorkandHasWork() {
        Object object = new Object();
        this.wb.addWork(object);
        AbstractWorkBagTest.assertTrue((boolean)this.wb.hasWork());
        Object object2 = this.wb.getWork();
        AbstractWorkBagTest.assertTrue((object2 != null ? 1 : 0) != 0);
        AbstractWorkBagTest.assertTrue((object2 == object ? 1 : 0) != 0);
    }

    protected List getWorkPieces() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= 10; ++i) {
            arrayList.add(String.valueOf(i));
        }
        return arrayList;
    }
}

