/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common;

import edu.ksu.cis.indus.common.FilteredCollection;
import edu.ksu.cis.indus.common.FilteredSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.AbstractMapDecorator;

final class FilteredMap
extends AbstractMapDecorator {
    private final Predicate keyPred;
    private final Predicate valuePred;

    FilteredMap(Map map, Predicate predicate, Predicate predicate2) {
        super(map);
        if (predicate == null && predicate2 == null) {
            throw new IllegalArgumentException("If both predicates are null, please use an unfiltered map.");
        }
        this.keyPred = predicate;
        this.valuePred = predicate2;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = super.get(e);
            if (!this.validateValue(object)) continue;
            super.remove(e);
        }
    }

    public boolean containsKey(Object object) {
        return this.validateKey(object) && super.containsKey(object);
    }

    public boolean containsValue(Object object) {
        boolean bl = this.validateValue(object);
        if (bl) {
            Object e;
            Iterator iterator = this.keySet().iterator();
            for (bl = false; iterator.hasNext() && !bl; bl |= super.get(e).equals(object)) {
                e = iterator.next();
            }
        }
        return bl;
    }

    public Set entrySet() {
        Object object = this.valuePred == null && this.keyPred == null ? super.entrySet() : new FilteredSet(super.entrySet(), new Predicate(){

            public boolean evaluate(Object object) {
                Map.Entry entry;
                boolean bl = false;
                if (object instanceof Map.Entry && FilteredMap.this.validateKey((entry = (Map.Entry)object).getKey()) && FilteredMap.this.validateValue(entry.getValue())) {
                    bl = true;
                }
                return bl;
            }
        });
        return object;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof Map;
        Set set = ((Map)object).entrySet();
        Set set2 = this.entrySet();
        bl = set2.size() == set.size() && set.containsAll(set2);
        return bl;
    }

    public Object get(Object object) {
        Object object2;
        Object object3 = null;
        if (this.validateKey(object) && this.validateValue(object2 = super.get(object))) {
            object3 = object2;
        }
        return object3;
    }

    public int hashCode() {
        int n = 17;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            n += 37 * n + ((Object)entry).hashCode();
        }
        return n;
    }

    public Set keySet() {
        final Map map = this.getMap();
        return new FilteredSet(super.keySet(), new Predicate(){

            public boolean evaluate(Object object) {
                boolean bl = false;
                if (FilteredMap.this.validateKey(object) && FilteredMap.this.validateValue(map.get(object))) {
                    bl = true;
                }
                return bl;
            }
        });
    }

    public Object put(Object object, Object object2) {
        Object object3 = null;
        if (this.validateKey(object) && this.validateValue(object2)) {
            object3 = super.put(object, object2);
        }
        return object3;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Object object2;
        Object object3 = null;
        if (this.validateKey(object) && this.validateValue(object2 = super.get(object))) {
            object3 = super.remove(object);
        }
        return object3;
    }

    public int size() {
        return this.keySet().size();
    }

    public String toString() {
        Set set = this.entrySet();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer.append(" -> ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Collection values() {
        final Map map = this.getMap();
        return new FilteredCollection(super.values(), new Predicate(){

            public boolean evaluate(Object object) {
                boolean bl = false;
                Iterator iterator = FilteredMap.this.keySet().iterator();
                while (iterator.hasNext() && !bl) {
                    Object e = iterator.next();
                    if (!FilteredMap.this.validateKey(e) || !FilteredMap.this.validateValue(object) || map.get(e) != object) continue;
                    bl = true;
                }
                return bl;
            }
        });
    }

    boolean validateKey(Object object) {
        return this.keyPred != null && this.keyPred.evaluate(object) || this.keyPred == null;
    }

    boolean validateValue(Object object) {
        return this.valuePred != null && this.valuePred.evaluate(object) || this.valuePred == null;
    }
}

