/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common;

import java.util.ListIterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.AbstractListIteratorDecorator;

public class FilteredListIterator
extends AbstractListIteratorDecorator
implements ListIterator {
    private final Predicate predicate;

    public FilteredListIterator(ListIterator listIterator, Predicate predicate) {
        super(listIterator);
        this.predicate = predicate;
    }

    public void add(Object object) {
        if (this.predicate.evaluate(object)) {
            super.add(object);
        }
    }

    public boolean hasNext() {
        boolean bl = false;
        while (super.hasNext()) {
            Object e = this.iterator.next();
            if (!this.predicate.evaluate(e)) continue;
            bl = true;
            this.iterator.previous();
            break;
        }
        return bl;
    }

    public boolean hasPrevious() {
        boolean bl = false;
        while (super.hasPrevious()) {
            Object e = this.iterator.previous();
            if (!this.predicate.evaluate(e)) continue;
            bl = true;
            this.iterator.next();
            break;
        }
        return bl;
    }

    public Object next() {
        Object object;
        while (!this.predicate.evaluate(object = super.next())) {
        }
        return object;
    }

    public Object previous() {
        Object object;
        while (!this.predicate.evaluate(object = super.previous())) {
        }
        return object;
    }

    public void set(Object object) {
        if (this.predicate.evaluate(object)) {
            super.set(object);
        }
    }
}

