/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common;

import edu.ksu.cis.indus.common.FilteredCollection;
import edu.ksu.cis.indus.common.FilteredListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.list.AbstractListDecorator;

public final class FilteredList
extends AbstractListDecorator {
    private final FilteredCollection filteredCollection;
    private final Predicate predicate;

    public FilteredList(List list, Predicate predicate) {
        this.filteredCollection = new FilteredCollection(list, predicate);
        this.predicate = predicate;
    }

    public boolean isEmpty() {
        return this.filteredCollection.isEmpty();
    }

    public boolean add(Object object) {
        return this.filteredCollection.add(object);
    }

    public void add(int n, Object object) {
        if (this.predicate.evaluate(object)) {
            super.add(n, object);
        }
    }

    public boolean addAll(Collection collection) {
        return this.filteredCollection.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = n;
        FilterIterator filterIterator = new FilterIterator(collection.iterator(), this.predicate);
        while (filterIterator.hasNext()) {
            super.add(n2++, filterIterator.next());
        }
        return n2 != n;
    }

    public void clear() {
        this.filteredCollection.clear();
    }

    public boolean contains(Object object) {
        return this.filteredCollection.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.filteredCollection.containsAll(collection);
    }

    public boolean equals(Object object) {
        return this.filteredCollection.equals(object);
    }

    public Object get(int n) {
        Object object = null;
        if (this.predicate.evaluate(object)) {
            object = super.get(n);
        }
        return object;
    }

    public int hashCode() {
        return this.filteredCollection.hashCode();
    }

    public int indexOf(Object object) {
        int n = -1;
        if (this.predicate.evaluate(object)) {
            n = super.indexOf(object);
        }
        return n;
    }

    public Iterator iterator() {
        return this.filteredCollection.iterator();
    }

    public int lastIndexOf(Object object) {
        int n = -1;
        if (this.predicate.evaluate(object)) {
            n = super.lastIndexOf(object);
        }
        return n;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        return new FilteredListIterator(super.listIterator(n), this.predicate);
    }

    public boolean remove(Object object) {
        return this.filteredCollection.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.filteredCollection.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.filteredCollection.retainAll(collection);
    }

    public Object set(int n, Object object) {
        Object object2 = null;
        if (this.predicate.evaluate(object)) {
            object2 = super.set(n, object);
        }
        return object2;
    }

    public int size() {
        return this.filteredCollection.size();
    }

    public List subList(int n, int n2) {
        return new FilteredList(super.subList(n, n2), this.predicate);
    }

    public Object[] toArray() {
        return this.filteredCollection.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.filteredCollection.toArray(objectArray);
    }

    public String toString() {
        return this.filteredCollection.toString();
    }
}

