/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;
import org.apache.commons.collections.iterators.FilterIterator;

class FilteredCollection
extends AbstractCollectionDecorator {
    protected final Predicate predicate;

    public FilteredCollection(Collection collection, Predicate predicate) {
        super(collection);
        this.predicate = predicate;
    }

    public boolean isEmpty() {
        return super.isEmpty() || this.size() == 0;
    }

    public boolean add(Object object) {
        boolean bl = this.predicate.evaluate(object);
        if (bl) {
            bl = super.add(object);
        }
        return bl;
    }

    public boolean addAll(Collection collection) {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl &= this.add(iterator.next());
        }
        return bl;
    }

    public void clear() {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.predicate.evaluate(e)) continue;
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        return this.predicate.evaluate(object) && super.contains(object);
    }

    public boolean containsAll(Collection collection) {
        boolean bl;
        Iterator iterator = collection.iterator();
        for (bl = super.containsAll(collection); iterator.hasNext() && bl; bl &= this.predicate.evaluate(iterator.next())) {
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            bl = collection.size() == this.size() && collection.containsAll((Collection<?>)((Object)this));
        }
        return bl;
    }

    public int hashCode() {
        int n = 17;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            n += 37 * n + iterator.next().hashCode();
        }
        return n;
    }

    public Iterator iterator() {
        return new FilterIterator(super.iterator(), this.predicate);
    }

    public boolean remove(Object object) {
        boolean bl = false;
        if (this.predicate.evaluate(object)) {
            bl = super.remove(object);
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next());
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            objectArray[n++] = e;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        int n = this.size();
        if (objectArray2.length < n) {
            objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = iterator.next();
        }
        if (objectArray2.length > n) {
            objectArray2[n] = null;
        }
        return objectArray2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

