/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common;

import edu.ksu.cis.indus.common.FilteredMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;

public final class CollectionsUtilities {
    public static final Factory ARRAY_LIST_FACTORY = new Factory(){

        public Object create() {
            return new ArrayList();
        }
    };
    public static final Factory EMPTY_LIST_FACTORY = new Factory(){

        public Object create() {
            return Collections.EMPTY_LIST;
        }
    };
    public static final Factory EMPTY_SET_FACTORY = new Factory(){

        public Object create() {
            return Collections.EMPTY_SET;
        }
    };
    public static final Factory EMPTY_MAP_FACTORY = new Factory(){

        public Object create() {
            return Collections.EMPTY_MAP;
        }
    };
    public static final Factory HASH_MAP_FACTORY = new Factory(){

        public Object create() {
            return new HashMap();
        }
    };
    public static final Factory HASH_SET_FACTORY = new Factory(){

        public Object create() {
            return new HashSet();
        }
    };
    public static final Factory BIT_SET_FACTORY = new Factory(){

        public Object create() {
            return new BitSet();
        }
    };

    private CollectionsUtilities() {
    }

    public static Object getAtIndexFromList(List list, int n, Factory factory) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("invalid index: " + n + " < 0");
        }
        if (n > list.size()) {
            CollectionsUtilities.ensureSize(list, n, null);
            list.set(n, factory.create());
        } else if (list.get(n) == null) {
            list.set(n, factory.create());
        }
        return list.get(n);
    }

    public static Map getFilteredMap(Map map, Predicate predicate, Predicate predicate2) {
        return new FilteredMap(map, predicate, predicate2);
    }

    public static Object getFromMap(Map map, Object object, Factory factory) {
        if (!map.containsKey(object)) {
            map.put(object, factory.create());
        }
        return map.get(object);
    }

    public static Object getListAtIndexFromList(List list, int n) {
        return CollectionsUtilities.getAtIndexFromList(list, n, ARRAY_LIST_FACTORY);
    }

    public static List getListFromMap(Map map, Object object) {
        return (List)CollectionsUtilities.getFromMap(map, object, ARRAY_LIST_FACTORY);
    }

    public static Map getMapFromMap(Map map, Object object) {
        return (Map)CollectionsUtilities.getFromMap(map, object, HASH_MAP_FACTORY);
    }

    public static Object getSetAtIndexFromList(List list, int n) {
        return CollectionsUtilities.getAtIndexFromList(list, n, HASH_SET_FACTORY);
    }

    public static Set getSetFromMap(Map map, Object object) {
        return (Set)CollectionsUtilities.getFromMap(map, object, HASH_SET_FACTORY);
    }

    public static void ensureSize(List list, int n, Object object) {
        int n2 = list.size();
        if (n > n2) {
            for (int i = n - n2; i > 0; --i) {
                list.add(object);
            }
        }
    }

    public static void putAllIntoCollectionInMap(Map map, Object object, Collection collection, Factory factory) {
        Collection collection2 = (Collection)map.get(object);
        if (collection2 == null) {
            collection2 = (Collection)factory.create();
            map.put(object, collection2);
        }
        collection2.addAll(collection);
    }

    public static void putAllIntoListInMap(Map map, Object object, Collection collection) {
        CollectionsUtilities.putAllIntoCollectionInMap(map, object, collection, ARRAY_LIST_FACTORY);
    }

    public static void putAllIntoSetInMap(Map map, Object object, Collection collection) {
        CollectionsUtilities.putAllIntoCollectionInMap(map, object, collection, HASH_SET_FACTORY);
    }

    public static void putIntoCollectionInMap(Map map, Object object, Object object2, Factory factory) {
        Collection collection = (Collection)map.get(object);
        if (collection == null) {
            collection = (Collection)factory.create();
            map.put(object, collection);
        }
        collection.add(object2);
    }

    public static void putIntoListInMap(Map map, Object object, Object object2) {
        CollectionsUtilities.putIntoCollectionInMap(map, object, object2, ARRAY_LIST_FACTORY);
    }

    public static void putIntoSetInMap(Map map, Object object, Object object2) {
        CollectionsUtilities.putIntoCollectionInMap(map, object, object2, HASH_SET_FACTORY);
    }
}

