/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus;

import edu.ksu.cis.indus.IXMLBasedTest;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.IXMLizer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLTestCase;
import org.xml.sax.SAXException;

public abstract class AbstractXMLBasedTest
extends XMLTestCase
implements IXMLBasedTest {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$edu$ksu$cis$indus$AbstractXMLBasedTest == null ? (class$edu$ksu$cis$indus$AbstractXMLBasedTest = AbstractXMLBasedTest.class$("edu.ksu.cis.indus.AbstractXMLBasedTest")) : class$edu$ksu$cis$indus$AbstractXMLBasedTest));
    protected IXMLizer xmlizer;
    protected final Map info = new HashMap();
    protected String xmlControlDir;
    protected String xmlTestDir;
    private IJimpleIDGenerator idGenerator;
    private IStmtGraphFactory stmtGraphFactory;
    private String testMethodName = "";
    private String testName = "";
    static /* synthetic */ Class class$edu$ksu$cis$indus$AbstractXMLBasedTest;

    public final void setIdGenerator(IJimpleIDGenerator iJimpleIDGenerator) {
        this.idGenerator = iJimpleIDGenerator;
    }

    public void setName(String string) {
        this.testMethodName = string;
    }

    public String getName() {
        return this.testName;
    }

    public void setStmtGraphFactory(IStmtGraphFactory iStmtGraphFactory) {
        this.stmtGraphFactory = iStmtGraphFactory;
    }

    public void setTestName(String string) {
        this.testName = string;
        super.setName(string);
    }

    public void setXMLControlDir(String string) {
        this.xmlControlDir = string;
    }

    public void setXMLTestDir(String string) {
        this.xmlTestDir = string;
    }

    public void testXMLSimilarity() {
        String string = this.xmlTestDir + File.separator + this.getFileName();
        try {
            FileReader fileReader = new FileReader(new File(string));
            FileReader fileReader2 = new FileReader(new File(this.xmlControlDir + File.separator + this.getFileName()));
            Diff diff = new Diff((Reader)fileReader2, (Reader)fileReader);
            diff.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
            boolean bl = diff.similar();
            String string2 = diff.toString();
            ((Reader)fileReader).close();
            ((Reader)fileReader2).close();
            AbstractXMLBasedTest.assertTrue((String)string2, (boolean)bl);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)("Failed to read the xml file " + string), (Throwable)iOException);
            AbstractXMLBasedTest.fail((String)iOException.getMessage());
        }
        catch (SAXException sAXException) {
            LOGGER.error((Object)"Exception while parsing XML", (Throwable)sAXException);
            AbstractXMLBasedTest.fail((String)sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error((Object)"XML parser configuration related exception", (Throwable)parserConfigurationException);
            AbstractXMLBasedTest.fail((String)parserConfigurationException.getMessage());
        }
    }

    protected String getFileName() {
        return this.xmlizer.getFileName(this.getName());
    }

    protected final void setUp() throws Exception {
        this.xmlizer = this.getXMLizer();
        this.xmlizer.setXmlOutputDir(this.xmlTestDir);
        this.xmlizer.setGenerator(this.idGenerator);
        this.localSetup();
        this.xmlizer.writeXML(this.info);
    }

    protected abstract IXMLizer getXMLizer();

    protected void localSetup() throws Exception {
        this.info.put(AbstractXMLizer.FILE_NAME_ID, this.getName());
        this.info.put(IStmtGraphFactory.ID, this.stmtGraphFactory);
    }

    protected void runTest() throws Throwable {
        super.setName(this.testMethodName);
        super.runTest();
        super.setName(this.testName);
    }

    protected void tearDown() throws Exception {
        this.info.clear();
        if (this.stmtGraphFactory != null) {
            this.stmtGraphFactory.reset();
            this.stmtGraphFactory = null;
        }
        this.xmlizer = null;
        super.tearDown();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

