/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.peq.queryengine;

import edu.ksu.cis.peq.datastructures.WorkList;
import edu.ksu.cis.peq.fsm.interfaces.IFSM;
import edu.ksu.cis.peq.fsm.interfaces.IFSMToken;
import edu.ksu.cis.peq.fsm.interfaces.IState;
import edu.ksu.cis.peq.fsm.interfaces.ITransition;
import edu.ksu.cis.peq.graph.interfaces.IEdge;
import edu.ksu.cis.peq.graph.interfaces.IGraphEngine;
import edu.ksu.cis.peq.graph.interfaces.INode;
import edu.ksu.cis.peq.queryengine.AbstractQueryEngine;
import edu.ksu.cis.peq.queryengine.IMatcher;
import edu.ksu.cis.peq.queryengine.IQueryProgressListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class ExistentialQueryEngine$v1
extends AbstractQueryEngine {
    private Collection results = Collections.EMPTY_LIST;
    private Set listeners = new HashSet();

    public ExistentialQueryEngine$v1(IGraphEngine engine, IFSM fsm, IMatcher matcher) {
        super(engine, fsm, matcher);
    }

    public void execute() {
        HashSet<IFSMToken> _reachSet = new HashSet<IFSMToken>();
        WorkList _workList = new WorkList();
        this.fireProgressEvent(this, "Initializing work list", null);
        _workList.addAll(this.initializeWorkSet());
        HashSet<IFSMToken> _resultSet = new HashSet<IFSMToken>();
        while (_workList.hasWork()) {
            IFSMToken _fsmToken = (IFSMToken)_workList.getWork();
            _reachSet.add(_fsmToken);
            INode _reachNode = _fsmToken.getGraphEdge().getDstnNode();
            IState _reachState = _fsmToken.getTransitionEdge().getDstnState();
            if (_reachNode != null && _reachState != null) {
                _workList.addAll(this.matchAndMergeReach(_reachNode, _reachState, _fsmToken, _reachSet));
            }
            String _msg = "Processed node : " + _reachNode + " State : " + _reachState;
            this.fireProgressEvent(this, _msg, null);
            if (!_reachState.isFinalState()) continue;
            _resultSet.add(_fsmToken);
            this.fireProgressEvent(this, "Query result complete", null);
        }
        this.postProcess(_resultSet);
    }

    private Set initializeWorkSet() {
        LinkedHashSet _initSet = new LinkedHashSet();
        Set _initNodes = this.gEngine.getInitialNodes();
        Iterator _nodeIterator = _initNodes.iterator();
        IState _state = this.fsm.getInitialState();
        while (_nodeIterator.hasNext()) {
            INode _node = (INode)_nodeIterator.next();
            _initSet.addAll(this.matchNodeAndState(_node, _state));
        }
        return _initSet;
    }

    protected Set matchNodeAndState(INode node, IState state) {
        LinkedHashSet<IFSMToken> _matchSet = new LinkedHashSet<IFSMToken>();
        Set _edgeSet = node.getExitingEdges();
        Set _transitionSet = state.getExitingTransitions();
        for (IEdge _edge : _edgeSet) {
            for (ITransition _transition : _transitionSet) {
                IFSMToken _token = this.matcher.getMatch(_edge, _transition);
                if (_token.isEmpty()) continue;
                _matchSet.add(_token);
            }
        }
        return _matchSet;
    }

    protected Set matchAndMergeReach(INode node, IState state, IFSMToken parent, Set reachSet) {
        LinkedHashSet<IFSMToken> _matchSet = new LinkedHashSet<IFSMToken>();
        Set _edgeSet = node.getExitingEdges();
        Set _transitionSet = state.getExitingTransitions();
        for (IEdge _edge : _edgeSet) {
            for (ITransition _transition : _transitionSet) {
                IFSMToken _mergedToken;
                IFSMToken _token = this.matcher.getMatch(_edge, _transition);
                if (_token.isEmpty() || (_mergedToken = this.matcher.merge(parent, _token)).isEmpty() || reachSet.contains(_mergedToken)) continue;
                _matchSet.add(_mergedToken);
            }
        }
        return _matchSet;
    }

    protected void postProcess(Set resultSet) {
        if (resultSet.size() > 0) {
            this.results = new LinkedHashSet();
            for (IFSMToken _rtoken : resultSet) {
                LinkedList<IFSMToken> _lstResult = new LinkedList<IFSMToken>();
                _lstResult.add(_rtoken);
                IFSMToken _currToken = _rtoken;
                while (_currToken.getParent() != null) {
                    _lstResult.add(_currToken.getParent());
                    _currToken = _currToken.getParent();
                }
                Collections.reverse(_lstResult);
                this.results.add(_lstResult);
            }
        }
    }

    private void fireProgressEvent(Object source, String message, Object information) {
        final IQueryProgressListener.QueryProgressEvent _event = new IQueryProgressListener.QueryProgressEvent(source, message, information);
        Thread _t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Set set = ExistentialQueryEngine$v1.this.listeners;
                synchronized (set) {
                    Iterator _it = ExistentialQueryEngine$v1.this.listeners.iterator();
                    while (_it.hasNext()) {
                        ((IQueryProgressListener)_it.next()).queryProgress(_event);
                    }
                }
            }
        };
        _t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IQueryProgressListener queryListener) {
        Set set = this.listeners;
        synchronized (set) {
            if (!this.listeners.contains(queryListener)) {
                this.listeners.add(queryListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IQueryProgressListener queryListener) {
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.contains(queryListener)) {
                this.listeners.remove(queryListener);
            }
        }
    }

    public Collection getResults() {
        return this.results;
    }
}

