/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.automata.utilities;

import edu.ksu.cis.automata.interfaces.IAutomata;
import edu.ksu.cis.automata.interfaces.IState;
import edu.ksu.cis.automata.interfaces.ISymbol;
import edu.ksu.cis.automata.interfaces.ITransition;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class AutomataDescriber {
    private IAutomata automata;
    private int noOfStates;
    private int noOfTransitions;
    private int noOfSymbols;
    private String stateAndTransDescrption;

    public AutomataDescriber(IAutomata automata) {
        this.automata = automata;
    }

    public void process() {
        StringBuffer sb = new StringBuffer();
        IState initState = this.automata.getInitialState();
        LinkedList<IState> workSet = new LinkedList<IState>();
        HashSet<IState> reachSet = new HashSet<IState>();
        HashSet<ISymbol> symbolSet = new HashSet<ISymbol>();
        workSet.add(initState);
        while (!workSet.isEmpty()) {
            IState state = (IState)workSet.remove(0);
            if (reachSet.contains(state)) continue;
            reachSet.add(state);
            ++this.noOfStates;
            Set transSet = state.getExitingTransitions();
            for (ITransition trans : transSet) {
                ++this.noOfTransitions;
                if (!trans.isEpsTransition()) {
                    symbolSet.add(trans.getSymbol());
                }
                workSet.add(trans.getDstnState());
                sb.append(trans);
            }
        }
        this.noOfSymbols = symbolSet.size();
        this.stateAndTransDescrption = sb.toString();
    }

    public String printAutomata() {
        StringBuffer sb = new StringBuffer();
        sb.append("<automata>\n");
        sb.append("<stateCount>" + this.noOfStates + "</stateCount>\n");
        sb.append("<transitionCount>" + this.noOfTransitions + "</transitionCount>\n");
        sb.append("<symbolCount>" + this.noOfSymbols + "</symbolCount>\n");
        sb.append(this.stateAndTransDescrption);
        sb.append("\n</automata>");
        return sb.toString();
    }
}

