/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import soot.util.BitVector;
import soot.util.Numberable;
import soot.util.Numberer;

public final class NumberedSet {
    private Numberable[] array = new Numberable[8];
    private BitVector bits;
    private int size = 0;
    private Numberer universe;

    public NumberedSet(Numberer universe) {
        this.universe = universe;
    }

    public boolean add(Numberable o) {
        if (this.array != null) {
            int pos = this.findPosition(o);
            if (this.array[pos] == o) {
                return false;
            }
            ++this.size;
            if (this.size * 3 > this.array.length * 2) {
                this.doubleSize();
                if (this.array != null) {
                    pos = this.findPosition(o);
                } else {
                    int number = o.getNumber();
                    if (number == 0) {
                        throw new RuntimeException("unnumbered");
                    }
                    return this.bits.set(number);
                }
            }
            this.array[pos] = o;
            return true;
        }
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        if (this.bits.set(number)) {
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean contains(Numberable o) {
        if (this.array != null) {
            return this.array[this.findPosition(o)] != null;
        }
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        return this.bits.get(number);
    }

    private final int findPosition(Numberable o) {
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        number &= this.array.length - 1;
        while (this.array[number] != o) {
            if (this.array[number] == null) {
                return number;
            }
            number = number + 1 & this.array.length - 1;
        }
        return number;
    }

    private final void doubleSize() {
        int uniSize = this.universe.size();
        if (this.array.length * 128 > uniSize) {
            this.bits = new BitVector(uniSize);
            Numberable[] oldArray = this.array;
            this.array = null;
            for (int i = 0; i < oldArray.length; ++i) {
                Numberable element = oldArray[i];
                if (element == null) continue;
                this.bits.set(element.getNumber());
            }
        } else {
            Numberable[] oldArray = this.array;
            this.array = new Numberable[this.array.length * 2];
            for (int i = 0; i < oldArray.length; ++i) {
                Numberable element = oldArray[i];
                if (element == null) continue;
                this.array[this.findPosition((Numberable)element)] = element;
            }
        }
    }

    public Iterator iterator() {
        if (this.array == null) {
            return new BitSetIterator(this);
        }
        return new NumberedSetIterator(this);
    }

    public final int size() {
        return this.size;
    }

    class NumberedSetIterator
    implements Iterator {
        NumberedSet set;
        int cur = 0;

        NumberedSetIterator(NumberedSet set) {
            this.set = set;
            this.seekNext();
        }

        protected final void seekNext() {
            try {
                while (this.set.array[this.cur] == null) {
                    ++this.cur;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.cur = -1;
            }
        }

        public final boolean hasNext() {
            return this.cur != -1;
        }

        public void remove() {
            throw new RuntimeException("Not implemented.");
        }

        public final Object next() {
            Numberable ret = this.set.array[this.cur];
            ++this.cur;
            this.seekNext();
            return ret;
        }
    }

    class BitSetIterator
    implements Iterator {
        soot.util.BitSetIterator iter;

        BitSetIterator(NumberedSet set) {
            this.iter = set.bits.iterator();
        }

        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        public void remove() {
            throw new RuntimeException("Not implemented.");
        }

        public final Object next() {
            return NumberedSet.this.universe.get(this.iter.next());
        }
    }
}

