/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import soot.util.Numberable;
import soot.util.Numberer;

public final class LargeNumberedMap {
    private Object[] values;
    private long[] bits;
    private int size = 0;
    private Numberer universe;

    public LargeNumberedMap(Numberer universe) {
        this.universe = universe;
        int newsize = universe.size();
        if (newsize < 8) {
            newsize = 8;
        }
        this.values = new Object[newsize];
    }

    public boolean put(Numberable key, Object value) {
        int number = key.getNumber();
        if (number == 0) {
            throw new RuntimeException("oops, forgot to initialize");
        }
        if (number >= this.values.length) {
            Object[] oldValues = this.values;
            this.values = new Object[this.universe.size() * 2 + 5];
            System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
        }
        boolean ret = this.values[number] != value;
        this.values[number] = value;
        return ret;
    }

    public Object get(Numberable key) {
        int i = key.getNumber();
        if (i >= this.values.length) {
            return null;
        }
        return this.values[i];
    }
}

