/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Timers;
import soot.Unit;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.SimpleLiveLocalsAnalysis;

public class SimpleLiveLocals
implements LiveLocals {
    Map unitToLocalsAfter;
    Map unitToLocalsBefore;

    public SimpleLiveLocals(UnitGraph graph) {
        if (Options.v().time()) {
            Timers.v().liveTimer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + graph.getBody().getMethod().getName() + "]     Constructing SimpleLiveLocals...");
        }
        SimpleLiveLocalsAnalysis analysis = new SimpleLiveLocalsAnalysis(graph);
        if (Options.v().time()) {
            Timers.v().livePostTimer.start();
        }
        this.unitToLocalsAfter = new HashMap(graph.size() * 2 + 1, 0.7f);
        this.unitToLocalsBefore = new HashMap(graph.size() * 2 + 1, 0.7f);
        Iterator unitIt = graph.iterator();
        while (unitIt.hasNext()) {
            Unit s = (Unit)unitIt.next();
            FlowSet set = (FlowSet)analysis.getFlowBefore(s);
            this.unitToLocalsBefore.put(s, Collections.unmodifiableList(set.toList()));
            set = (FlowSet)analysis.getFlowAfter(s);
            this.unitToLocalsAfter.put(s, Collections.unmodifiableList(set.toList()));
        }
        if (Options.v().time()) {
            Timers.v().livePostTimer.end();
        }
        if (Options.v().time()) {
            Timers.v().liveTimer.end();
        }
    }

    public List getLiveLocalsAfter(Unit s) {
        return (List)this.unitToLocalsAfter.get(s);
    }

    public List getLiveLocalsBefore(Unit s) {
        return (List)this.unitToLocalsBefore.get(s);
    }
}

