/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.IdentityUnit;
import soot.Local;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Type;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.GroupIntPair;
import soot.options.Options;
import soot.toolkits.scalar.FastColorer;
import soot.util.DeterministicHashMap;

public class LocalPacker
extends BodyTransformer {
    public LocalPacker(Singletons.Global g) {
    }

    public static LocalPacker v() {
        return G.v().LocalPacker();
    }

    protected void internalTransform(Body body, String phaseName, Map options) {
        Unit s;
        boolean isUnsplit = PhaseOptions.getBoolean(options, "unsplit-original-locals");
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Packing locals...");
        }
        DeterministicHashMap localToGroup = new DeterministicHashMap(body.getLocalCount() * 2 + 1, 0.7f);
        HashMap<Type, Integer> groupToColorCount = new HashMap<Type, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        HashMap<Local, Integer> localToColor = new HashMap<Local, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        Iterator localIt = body.getLocals().iterator();
        while (localIt.hasNext()) {
            Local l = (Local)localIt.next();
            Type g = l.getType();
            localToGroup.put(l, g);
            if (groupToColorCount.containsKey(g)) continue;
            groupToColorCount.put(g, new Integer(0));
        }
        Iterator codeIt = body.getUnits().iterator();
        while (codeIt.hasNext()) {
            s = (Unit)codeIt.next();
            if (!(s instanceof IdentityUnit) || !(((IdentityUnit)s).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityUnit)s).getLeftOp();
            Object group = localToGroup.get(l);
            int count = (Integer)groupToColorCount.get(group);
            localToColor.put(l, new Integer(count));
            groupToColorCount.put((Type)group, new Integer(++count));
        }
        if (isUnsplit) {
            FastColorer.unsplitAssignColorsToLocals(body, localToGroup, localToColor, groupToColorCount);
        } else {
            FastColorer.assignColorsToLocals(body, localToGroup, localToColor, groupToColorCount);
        }
        ArrayList originalLocals = new ArrayList();
        HashMap<Local, Local> localToNewLocal = new HashMap<Local, Local>(body.getLocalCount() * 2 + 1, 0.7f);
        HashMap<GroupIntPair, Local> groupIntToLocal = new HashMap<GroupIntPair, Local>(body.getLocalCount() * 2 + 1, 0.7f);
        originalLocals.addAll(body.getLocals());
        body.getLocals().clear();
        Iterator localIt2 = originalLocals.iterator();
        while (localIt2.hasNext()) {
            Local newLocal;
            int color;
            Local original = (Local)localIt2.next();
            Object group = localToGroup.get(original);
            GroupIntPair pair = new GroupIntPair(group, color = ((Integer)localToColor.get(original)).intValue());
            if (groupIntToLocal.containsKey(pair)) {
                newLocal = (Local)groupIntToLocal.get(pair);
            } else {
                newLocal = (Local)original.clone();
                newLocal.setType((Type)group);
                int signIndex = newLocal.getName().indexOf("#");
                if (signIndex != -1) {
                    newLocal.setName(newLocal.getName().substring(0, signIndex));
                }
                groupIntToLocal.put(pair, newLocal);
                body.getLocals().add(newLocal);
            }
            localToNewLocal.put(original, newLocal);
        }
        codeIt = body.getUnits().iterator();
        while (codeIt.hasNext()) {
            Local l;
            ValueBox box;
            s = (Unit)codeIt.next();
            Iterator boxIt = s.getUseBoxes().iterator();
            while (boxIt.hasNext()) {
                box = (ValueBox)boxIt.next();
                if (!(box.getValue() instanceof Local)) continue;
                l = (Local)box.getValue();
                box.setValue((Local)localToNewLocal.get(l));
            }
            boxIt = s.getDefBoxes().iterator();
            while (boxIt.hasNext()) {
                box = (ValueBox)boxIt.next();
                if (!(box.getValue() instanceof Local)) continue;
                l = (Local)box.getValue();
                box.setValue((Local)localToNewLocal.get(l));
            }
        }
    }
}

