/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.PatchingChain;
import soot.Timers;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.BranchedFlowAnalysis;

public abstract class ForwardBranchedFlowAnalysis
extends BranchedFlowAnalysis {
    public ForwardBranchedFlowAnalysis(UnitGraph graph) {
        super(graph);
    }

    protected boolean isForward() {
        return true;
    }

    private void accumulateAfterFlowSets(Unit s, Object[] flowRepositories, List previousAfterFlows) {
        int repCount = 0;
        previousAfterFlows.clear();
        if (s.fallsThrough()) {
            this.copy(((List)this.unitToAfterFallFlow.get(s)).get(0), flowRepositories[repCount]);
            previousAfterFlows.add(flowRepositories[repCount++]);
        }
        if (s.branches()) {
            List l = (List)this.unitToAfterBranchFlow.get(s);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                Object fs = it.next();
                this.copy(fs, flowRepositories[repCount]);
                previousAfterFlows.add(flowRepositories[repCount++]);
            }
        }
    }

    protected void doAnalysis() {
        Unit s;
        LinkedList<Unit> changedUnits = new LinkedList<Unit>();
        HashSet<Unit> changedUnitsSet = new HashSet<Unit>();
        HashMap unitToIncomingFlowSets = new HashMap(this.graph.size() * 2 + 1, 0.7f);
        int numNodes = this.graph.size();
        int numComputations = 0;
        int maxBranchSize = 0;
        Iterator it = this.graph.iterator();
        while (it.hasNext()) {
            s = (Unit)it.next();
            unitToIncomingFlowSets.put(s, new ArrayList());
        }
        PatchingChain sl = ((UnitGraph)this.graph).getBody().getUnits();
        Iterator it2 = this.graph.iterator();
        while (it2.hasNext()) {
            Unit s2 = (Unit)it2.next();
            changedUnits.addLast(s2);
            changedUnitsSet.add(s2);
            this.unitToBeforeFlow.put(s2, this.newInitialFlow());
            if (s2.fallsThrough()) {
                ArrayList<Object> fl = new ArrayList<Object>();
                fl.add(this.newInitialFlow());
                this.unitToAfterFallFlow.put(s2, fl);
                List l = (List)unitToIncomingFlowSets.get(sl.getSuccOf(s2));
                l.addAll(fl);
            } else {
                this.unitToAfterFallFlow.put(s2, new ArrayList());
            }
            if (s2.branches()) {
                ArrayList<Object> l = new ArrayList<Object>();
                Iterator boxIt = s2.getUnitBoxes().iterator();
                while (boxIt.hasNext()) {
                    Object f = this.newInitialFlow();
                    l.add(f);
                    Unit ss = ((UnitBox)boxIt.next()).getUnit();
                    List incList = (List)unitToIncomingFlowSets.get(ss);
                    incList.add(f);
                }
                this.unitToAfterBranchFlow.put(s2, l);
            } else {
                this.unitToAfterBranchFlow.put(s2, new ArrayList());
            }
            if (s2.getUnitBoxes().size() <= maxBranchSize) continue;
            maxBranchSize = s2.getUnitBoxes().size();
        }
        it = this.graph.getHeads().iterator();
        while (it.hasNext()) {
            s = it.next();
            this.unitToBeforeFlow.put(s, this.entryInitialFlow());
        }
        if (this.treatTrapHandlersAsEntries()) {
            Iterator trapIt = ((UnitGraph)this.graph).getBody().getTraps().iterator();
            while (trapIt.hasNext()) {
                Trap trap = (Trap)trapIt.next();
                Unit handler = trap.getHandlerUnit();
                this.unitToBeforeFlow.put(handler, this.entryInitialFlow());
            }
        }
        ArrayList previousAfterFlows = new ArrayList();
        ArrayList afterFlows = new ArrayList();
        Object[] flowRepositories = new Object[maxBranchSize + 1];
        for (int i = 0; i < maxBranchSize + 1; ++i) {
            flowRepositories[i] = this.newInitialFlow();
        }
        Object[] previousFlowRepositories = new Object[maxBranchSize + 1];
        for (int i = 0; i < maxBranchSize + 1; ++i) {
            previousFlowRepositories[i] = this.newInitialFlow();
        }
        while (!changedUnits.isEmpty()) {
            Unit s3 = (Unit)changedUnits.removeFirst();
            changedUnitsSet.remove(s3);
            this.accumulateAfterFlowSets(s3, previousFlowRepositories, previousAfterFlows);
            List preds = (List)unitToIncomingFlowSets.get(s3);
            Object beforeFlow = this.unitToBeforeFlow.get(s3);
            if (preds.size() == 1) {
                this.copy(preds.get(0), beforeFlow);
            } else if (preds.size() != 0) {
                Iterator predIt = preds.iterator();
                this.copy(predIt.next(), beforeFlow);
                while (predIt.hasNext()) {
                    Object otherBranchFlow = predIt.next();
                    this.merge(beforeFlow, otherBranchFlow, beforeFlow);
                }
            }
            Object afterFallFlow = this.unitToAfterFallFlow.get(s3);
            Object afterBranchFlow = this.unitToAfterBranchFlow.get(s3);
            this.flowThrough(beforeFlow, s3, (List)afterFallFlow, (List)afterBranchFlow);
            ++numComputations;
            this.accumulateAfterFlowSets(s3, flowRepositories, afterFlows);
            if (((Object)afterFlows).equals(previousAfterFlows)) continue;
            Iterator succIt = this.graph.getSuccsOf(s3).iterator();
            while (succIt.hasNext()) {
                Unit succ = (Unit)succIt.next();
                if (changedUnitsSet.contains(succ)) continue;
                changedUnits.addLast(succ);
                changedUnitsSet.add(succ);
            }
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }
}

