/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.FlowSet;

public class ArraySparseSet
extends AbstractFlowSet {
    static final int DEFAULT_SIZE = 8;
    int numElements;
    int maxElements;
    Object[] elements;

    public ArraySparseSet() {
        this.maxElements = 8;
        this.elements = new Object[8];
        this.numElements = 0;
    }

    private ArraySparseSet(ArraySparseSet other) {
        this.numElements = other.numElements;
        this.maxElements = other.maxElements;
        this.elements = (Object[])other.elements.clone();
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof ArraySparseSet;
    }

    public Object clone() {
        return new ArraySparseSet(this);
    }

    public Object emptySet() {
        return new ArraySparseSet();
    }

    public void clear() {
        this.numElements = 0;
    }

    public int size() {
        return this.numElements;
    }

    public boolean isEmpty() {
        return this.numElements == 0;
    }

    public List toList() {
        Object[] copiedElements = new Object[this.numElements];
        System.arraycopy(this.elements, 0, copiedElements, 0, this.numElements);
        return Arrays.asList(copiedElements);
    }

    public void add(Object e) {
        if (!this.contains(e)) {
            if (this.numElements == this.maxElements) {
                this.doubleCapacity();
            }
            this.elements[this.numElements++] = e;
        }
    }

    private void doubleCapacity() {
        int newSize = this.maxElements * 2;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    public void remove(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            this.elements[i] = this.elements[--this.numElements];
            return;
        }
    }

    private void removeElementAt(int index) {
        this.elements[index] = this.elements[--this.numElements];
    }

    public void union(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other) {
                for (int i = 0; i < this.numElements; ++i) {
                    dest.add(this.elements[i]);
                }
            } else {
                if (this != dest) {
                    this.copy(dest);
                }
                for (int i = 0; i < other.numElements; ++i) {
                    dest.add(other.elements[i]);
                }
            }
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    public void intersection(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet workingSet;
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new ArraySparseSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (int i = 0; i < this.numElements; ++i) {
                if (!other.contains(this.elements[i])) continue;
                workingSet.add(this.elements[i]);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    public void difference(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArraySparseSet workingSet;
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new ArraySparseSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (int i = 0; i < this.numElements; ++i) {
                if (other.contains(this.elements[i])) continue;
                workingSet.add(this.elements[i]);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    public boolean contains(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            ArraySparseSet other = (ArraySparseSet)otherFlow;
            if (other.numElements != this.numElements) {
                return false;
            }
            int size = this.numElements;
            for (int i = 0; i < size; ++i) {
                if (other.contains(this.elements[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(otherFlow);
    }

    public void copy(FlowSet destFlow) {
        if (this.sameType(destFlow)) {
            ArraySparseSet dest = (ArraySparseSet)destFlow;
            while (dest.maxElements < this.maxElements) {
                dest.doubleCapacity();
            }
            dest.numElements = this.numElements;
            System.arraycopy(this.elements, 0, dest.elements, 0, this.numElements);
        } else {
            super.copy(destFlow);
        }
    }

    private static class SparseArrayList
    extends AbstractList {
        private Object[] array;
        private int realSize;

        public SparseArrayList(Object[] array, int realSize) {
            this.array = array;
            this.realSize = realSize;
        }

        public Object get(int index) {
            return this.array[index];
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.realSize;
        }

        public Object clone() {
            return this.array.clone();
        }
    }
}

