/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Singletons;
import soot.toolkits.graph.DirectedGraph;

public class SlowPseudoTopologicalOrderer {
    public static final boolean REVERSE = true;
    private Map stmtToColor;
    private static final int WHITE = 0;
    private static final int GRAY = 1;
    private static final int BLACK = 2;
    private LinkedList order;
    private boolean mIsReversed = false;
    private DirectedGraph graph;
    private List reverseOrder;
    private HashMap succsMap = new HashMap();

    public SlowPseudoTopologicalOrderer(Singletons.Global g) {
    }

    public static SlowPseudoTopologicalOrderer v() {
        return G.v().SlowPseudoTopologicalOrderer();
    }

    public SlowPseudoTopologicalOrderer() {
    }

    public SlowPseudoTopologicalOrderer(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    public List newList(DirectedGraph g) {
        return this.computeOrder(g);
    }

    public void setReverseOrder(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    public boolean isReverseOrder() {
        return this.mIsReversed;
    }

    LinkedList computeOrder(DirectedGraph g) {
        Object s;
        this.stmtToColor = new HashMap();
        this.order = new LinkedList();
        this.graph = g;
        PseudoTopologicalReverseOrderer orderer = new PseudoTopologicalReverseOrderer();
        this.reverseOrder = orderer.newList(g);
        Iterator stmtIt = g.iterator();
        while (stmtIt.hasNext()) {
            s = stmtIt.next();
            this.stmtToColor.put(s, new Integer(0));
        }
        stmtIt = g.iterator();
        while (stmtIt.hasNext()) {
            s = stmtIt.next();
            if ((Integer)this.stmtToColor.get(s) != 0) continue;
            this.visitNode(s);
        }
        return this.order;
    }

    private void visitNode(Object startStmt) {
        LinkedList<Object> stmtStack = new LinkedList<Object>();
        LinkedList<Integer> indexStack = new LinkedList<Integer>();
        this.stmtToColor.put(startStmt, new Integer(1));
        stmtStack.addLast(startStmt);
        indexStack.addLast(new Integer(-1));
        while (!stmtStack.isEmpty()) {
            Object childNode;
            int toVisitIndex = (Integer)indexStack.removeLast();
            Object toVisitNode = stmtStack.getLast();
            indexStack.addLast(new Integer(++toVisitIndex));
            if (toVisitIndex >= this.graph.getSuccsOf(toVisitNode).size()) {
                if (this.mIsReversed) {
                    this.order.addLast(toVisitNode);
                } else {
                    this.order.addFirst(toVisitNode);
                }
                this.stmtToColor.put(toVisitNode, new Integer(2));
                stmtStack.removeLast();
                indexStack.removeLast();
                continue;
            }
            LinkedList orderedSuccs = (LinkedList)this.succsMap.get(toVisitNode);
            if (orderedSuccs == null) {
                orderedSuccs = new LinkedList();
                this.succsMap.put(toVisitNode, orderedSuccs);
                List allsuccs = this.graph.getSuccsOf(toVisitNode);
                for (int i = 0; i < allsuccs.size(); ++i) {
                    int j;
                    Object cur = allsuccs.get(i);
                    for (j = 0; j < orderedSuccs.size(); ++j) {
                        int idx2;
                        Object comp = orderedSuccs.get(j);
                        int idx1 = this.reverseOrder.indexOf(cur);
                        if (idx1 < (idx2 = this.reverseOrder.indexOf(comp))) break;
                    }
                    orderedSuccs.add(j, cur);
                }
            }
            if ((Integer)this.stmtToColor.get(childNode = orderedSuccs.get(toVisitIndex)) != 0) continue;
            this.stmtToColor.put(childNode, new Integer(1));
            stmtStack.addLast(childNode);
            indexStack.addLast(new Integer(-1));
        }
    }

    private class PseudoTopologicalReverseOrderer {
        private Map stmtToColor;
        private static final int WHITE = 0;
        private static final int GRAY = 1;
        private static final int BLACK = 2;
        private LinkedList order;
        private boolean mIsReversed = false;
        private DirectedGraph graph;

        private PseudoTopologicalReverseOrderer() {
        }

        List newList(DirectedGraph g) {
            return this.computeOrder(g);
        }

        LinkedList computeOrder(DirectedGraph g) {
            Object s;
            this.stmtToColor = new HashMap();
            this.order = new LinkedList();
            this.graph = g;
            Iterator stmtIt = g.iterator();
            while (stmtIt.hasNext()) {
                s = stmtIt.next();
                this.stmtToColor.put(s, new Integer(0));
            }
            stmtIt = g.iterator();
            while (stmtIt.hasNext()) {
                s = stmtIt.next();
                if ((Integer)this.stmtToColor.get(s) != 0) continue;
                this.visitNode(s);
            }
            return this.order;
        }

        private void visitNode(Object startStmt) {
            LinkedList<Object> stmtStack = new LinkedList<Object>();
            LinkedList<Integer> indexStack = new LinkedList<Integer>();
            this.stmtToColor.put(startStmt, new Integer(1));
            stmtStack.addLast(startStmt);
            indexStack.addLast(new Integer(-1));
            while (!stmtStack.isEmpty()) {
                int toVisitIndex = (Integer)indexStack.removeLast();
                Object toVisitNode = stmtStack.getLast();
                indexStack.addLast(new Integer(++toVisitIndex));
                if (toVisitIndex >= this.graph.getPredsOf(toVisitNode).size()) {
                    if (this.mIsReversed) {
                        this.order.addLast(toVisitNode);
                    } else {
                        this.order.addFirst(toVisitNode);
                    }
                    this.stmtToColor.put(toVisitNode, new Integer(2));
                    stmtStack.removeLast();
                    indexStack.removeLast();
                    continue;
                }
                Object childNode = this.graph.getPredsOf(toVisitNode).get(toVisitIndex);
                if ((Integer)this.stmtToColor.get(childNode) != 0) continue;
                this.stmtToColor.put(childNode, new Integer(1));
                stmtStack.addLast(childNode);
                indexStack.addLast(new Integer(-1));
            }
        }
    }
}

