/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.PatchingChain;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.shimple.ShimpleBody;
import soot.toolkits.scalar.LocalDefs;
import soot.util.SingletonList;

public class ShimpleLocalDefs
implements LocalDefs {
    protected Map localToDefs;

    public ShimpleLocalDefs(ShimpleBody sb) {
        if (!sb.isSSA()) {
            throw new RuntimeException("ShimpleBody is not in proper SSA form as required by ShimpleLocalDefs.  You may need to rebuild it or use SimpleLocalDefs instead.");
        }
        PatchingChain unitsChain = sb.getUnits();
        Iterator unitsIt = unitsChain.iterator();
        this.localToDefs = new HashMap(unitsChain.size() * 2 + 1, 0.7f);
        while (unitsIt.hasNext()) {
            Unit unit = (Unit)unitsIt.next();
            Iterator defBoxesIt = unit.getDefBoxes().iterator();
            while (defBoxesIt.hasNext()) {
                Value value = ((ValueBox)defBoxesIt.next()).getValue();
                if (!(value instanceof Local)) continue;
                this.localToDefs.put(value, new SingletonList(unit));
            }
        }
    }

    public List getDefsOf(Local l) {
        List defs = (List)this.localToDefs.get(l);
        if (defs == null) {
            throw new RuntimeException("Local not found in Body.");
        }
        return defs;
    }

    public List getDefsOfAt(Local l, Unit s) {
        Iterator boxIt = s.getUseBoxes().iterator();
        boolean defined = false;
        while (boxIt.hasNext()) {
            Value value = ((ValueBox)boxIt.next()).getValue();
            if (!value.equals(l)) continue;
            defined = true;
            break;
        }
        if (!defined) {
            throw new RuntimeException("Illegal LocalDefs query; local " + l + " is not being used at " + s);
        }
        return this.getDefsOf(l);
    }
}

