/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.Iterator;
import java.util.Map;
import soot.Local;
import soot.Type;
import soot.UnitBoxOwner;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.Expr;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.shimple.PhiExpr;
import soot.util.Switch;

public class SEvaluator {
    public static boolean isValueConstantValued(Value op) {
        if (op instanceof PhiExpr) {
            Iterator argsIt = ((PhiExpr)op).getValues().iterator();
            Constant firstConstant = null;
            while (argsIt.hasNext()) {
                Value arg = (Value)argsIt.next();
                if (!(arg instanceof Constant)) {
                    return false;
                }
                if (firstConstant == null) {
                    firstConstant = (Constant)arg;
                    continue;
                }
                if (firstConstant.equals(arg)) continue;
                return false;
            }
            return true;
        }
        return Evaluator.isValueConstantValued(op);
    }

    public static Value getConstantValueOf(Value op) {
        if (!(op instanceof PhiExpr)) {
            return Evaluator.getConstantValueOf(op);
        }
        if (!SEvaluator.isValueConstantValued(op)) {
            return null;
        }
        return ((PhiExpr)op).getValue(0);
    }

    public static Constant getFuzzyConstantValueOf(Value v) {
        if (v instanceof Constant) {
            return (Constant)v;
        }
        if (v instanceof Local) {
            return BottomConstant.v();
        }
        if (!(v instanceof Expr)) {
            return BottomConstant.v();
        }
        Expr expr = (Expr)v;
        Constant constant = null;
        if (expr instanceof PhiExpr) {
            PhiExpr phi = (PhiExpr)expr;
            Iterator argsIt = phi.getValues().iterator();
            while (argsIt.hasNext()) {
                Value arg = (Value)argsIt.next();
                if (!(arg instanceof Constant) || arg instanceof TopConstant) continue;
                if (constant == null) {
                    constant = (Constant)arg;
                    continue;
                }
                if (constant.equals(arg)) continue;
                constant = BottomConstant.v();
                break;
            }
            if (constant == null) {
                constant = TopConstant.v();
            }
        } else {
            Iterator valueBoxesIt = expr.getUseBoxes().iterator();
            while (valueBoxesIt.hasNext()) {
                Value value = ((ValueBox)valueBoxesIt.next()).getValue();
                if (value instanceof BottomConstant) {
                    constant = BottomConstant.v();
                    break;
                }
                if (!(value instanceof TopConstant)) continue;
                constant = TopConstant.v();
            }
            if (constant == null) {
                constant = (Constant)SEvaluator.getConstantValueOf(expr);
            }
            if (constant == null) {
                constant = BottomConstant.v();
            }
        }
        return constant;
    }

    public static Constant getFuzzyConstantValueOf(Value v, Map localToConstant) {
        if (v instanceof Constant) {
            return (Constant)v;
        }
        if (v instanceof Local) {
            return (Constant)localToConstant.get(v);
        }
        if (!(v instanceof Expr)) {
            return BottomConstant.v();
        }
        Expr expr = (Expr)v.clone();
        Iterator useBoxIt = expr.getUseBoxes().iterator();
        while (useBoxIt.hasNext()) {
            Constant constant;
            ValueBox useBox = (ValueBox)useBoxIt.next();
            Value use = useBox.getValue();
            if (!(use instanceof Local) || !useBox.canContainValue(constant = (Constant)localToConstant.get(use))) continue;
            useBox.setValue(constant);
        }
        if (expr instanceof UnitBoxOwner) {
            ((UnitBoxOwner)((Object)expr)).clearUnitBoxes();
        }
        return SEvaluator.getFuzzyConstantValueOf(expr);
    }

    public static class BottomConstant
    extends MetaConstant {
        private static final BottomConstant constant = new BottomConstant();

        private BottomConstant() {
        }

        public static Constant v() {
            return constant;
        }

        public Type getType() {
            return UnknownType.v();
        }

        public void apply(Switch sw) {
            throw new RuntimeException("Not implemented.");
        }
    }

    public static class TopConstant
    extends MetaConstant {
        private static final TopConstant constant = new TopConstant();

        private TopConstant() {
        }

        public static Constant v() {
            return constant;
        }

        public Type getType() {
            return UnknownType.v();
        }

        public void apply(Switch sw) {
            throw new RuntimeException("Not implemented.");
        }
    }

    public static abstract class MetaConstant
    extends Constant {
    }
}

