/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal.analysis;

import java.util.Iterator;
import java.util.List;
import soot.shimple.internal.analysis.DominatorNode;

public class DominanceFrontier {
    public DominanceFrontier() {
    }

    public DominanceFrontier(List dominatorNodeHeads) {
        Iterator headsIt = dominatorNodeHeads.iterator();
        while (headsIt.hasNext()) {
            this.bottomUpDispatch((DominatorNode)headsIt.next());
        }
    }

    public void bottomUpDispatch(DominatorNode node) {
        if (node.isFrontierKnown()) {
            return;
        }
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            DominatorNode child = (DominatorNode)children.next();
            if (!child.isFrontierKnown()) {
                this.bottomUpDispatch(child);
                continue;
            }
            this.processNode(child);
        }
        this.processNode(node);
    }

    public void processNode(DominatorNode node) {
        Iterator succsIt = node.getSuccs().iterator();
        while (succsIt.hasNext()) {
            DominatorNode succ = (DominatorNode)succsIt.next();
            if (succ.isImmediateDominator(node)) continue;
            node.addToDominanceFrontier(succ);
        }
        Iterator childIt = node.getChildren().iterator();
        while (childIt.hasNext()) {
            DominatorNode child = (DominatorNode)childIt.next();
            Iterator childFrontIt = child.getDominanceFrontier().iterator();
            while (childFrontIt.hasNext()) {
                DominatorNode childFront = (DominatorNode)childFrontIt.next();
                if (childFront.isImmediateDominator(node)) continue;
                node.addToDominanceFrontier(childFront);
            }
        }
        node.setFrontierKnown();
    }
}

