/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.options.Options;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;

public class ShimpleTransformer
extends SceneTransformer {
    public ShimpleTransformer(Singletons.Global g) {
    }

    public static ShimpleTransformer v() {
        return G.v().ShimpleTransformer();
    }

    protected void internalTransform(String phaseName, Map options) {
        if (Options.v().verbose()) {
            G.v().out.println("Transforming all classes in the Scene to Shimple...");
        }
        Iterator classesIt = Scene.v().getClasses().iterator();
        while (classesIt.hasNext()) {
            SootClass sClass = (SootClass)classesIt.next();
            if (sClass.isPhantom()) continue;
            Iterator methodsIt = sClass.getMethods().iterator();
            while (methodsIt.hasNext()) {
                SootMethod method = (SootMethod)methodsIt.next();
                if (!method.isConcrete()) continue;
                Body body = method.retrieveActiveBody();
                ShimpleBody sBody = null;
                if (body instanceof ShimpleBody) {
                    sBody = (ShimpleBody)body;
                    if (!sBody.isSSA()) {
                        sBody.rebuild();
                    }
                } else {
                    sBody = Shimple.v().newBody(body);
                }
                method.setActiveBody(sBody);
            }
        }
    }
}

