/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple;

import java.util.Map;
import soot.Body;
import soot.G;
import soot.SootMethod;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.StmtBody;
import soot.options.Options;
import soot.options.ShimpleOptions;
import soot.shimple.Shimple;
import soot.shimple.internal.SPatchingChain;
import soot.shimple.internal.ShimpleBodyBuilder;
import soot.util.HashChain;

public class ShimpleBody
extends StmtBody {
    protected ShimpleOptions options;
    protected boolean isSSA = false;

    ShimpleBody(SootMethod m, Map options) {
        super(m);
        this.options = new ShimpleOptions(options);
        this.setSSA(true);
        this.unitChain = new SPatchingChain(this, new HashChain());
    }

    ShimpleBody(Body body, Map options) {
        super(body.getMethod());
        if (!(body instanceof JimpleBody) && !(body instanceof ShimpleBody)) {
            throw new RuntimeException("Cannot construct ShimpleBody from given Body type.");
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + this.getMethod().getName() + "] Constructing ShimpleBody...");
        }
        this.options = new ShimpleOptions(options);
        this.unitChain = new SPatchingChain(this, new HashChain());
        this.importBodyContentsFrom(body);
        if (body instanceof ShimpleBody) {
            this.rebuild(true);
        } else {
            this.rebuild(false);
        }
    }

    public void rebuild() {
        this.rebuild(true);
    }

    public void rebuild(boolean hasPhiNodes) {
        new ShimpleBodyBuilder(this);
        this.setSSA(true);
    }

    public JimpleBody toJimpleBody() {
        ShimpleBody sBody = (ShimpleBody)this.clone();
        sBody.eliminatePhiNodes();
        JimpleBody jBody = Jimple.v().newBody(sBody.getMethod());
        jBody.importBodyContentsFrom(sBody);
        return jBody;
    }

    public void eliminatePhiNodes() {
        ShimpleBodyBuilder.eliminatePhiNodes(this);
        this.setSSA(false);
    }

    public Object clone() {
        ShimpleBody b = Shimple.v().newBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    public void setSSA(boolean isSSA) {
        this.isSSA = isSSA;
    }

    public boolean isSSA() {
        return this.isSSA;
    }

    public ShimpleOptions getOptions() {
        return this.options;
    }

    public void makeUniqueLocalNames() {
        ShimpleBodyBuilder.makeUniqueLocalNames(this);
    }
}

