/*
 * Decompiled with CFR 0.152.
 */
package soot.relations;

import java.util.Iterator;
import soot.jbuddy.JBuddy;
import soot.jbuddy.bddPair;
import soot.relations.Domain;
import soot.relations.JBuddyProfiler;
import soot.relations.PhysicalDomain;
import soot.util.Numberable;
import soot.util.Numberer;

public class Relation {
    public static final boolean CHECK = true;
    public static final boolean PROFILING = true;
    private Domain[] domains;
    private PhysicalDomain[] phys;
    private int bdd;

    public Domain[] domains() {
        return this.domains;
    }

    public PhysicalDomain[] phys() {
        return this.phys;
    }

    public int bdd() {
        return this.bdd;
    }

    public Relation(Domain[] domains, PhysicalDomain[] phys) {
        this.init(domains, phys);
    }

    private void init(Domain[] domains, PhysicalDomain[] phys) {
        this.domains = domains;
        this.phys = phys;
        this.bdd = JBuddy.bdd_false();
        this.checkForDupes(domains);
        this.checkForDupes(phys);
        if (phys.length != domains.length) {
            throw new RuntimeException();
        }
    }

    private void checkForDupes(Object[] ar) {
        for (int i = 0; i < ar.length; ++i) {
            if (ar[i] == null) {
                throw new RuntimeException();
            }
            for (int j = i + 1; j < ar.length; ++j) {
                if (!ar[j].equals(ar[i])) continue;
                throw new RuntimeException("Duplicates: " + Domain.toString(ar));
            }
        }
    }

    public Relation(Domain d1, PhysicalDomain p1) {
        Domain[] ds = new Domain[]{d1};
        PhysicalDomain[] ps = new PhysicalDomain[]{p1};
        this.init(ds, ps);
    }

    public Relation(Domain d1, Domain d2, PhysicalDomain p1, PhysicalDomain p2) {
        Domain[] ds = new Domain[]{d1, d2};
        PhysicalDomain[] ps = new PhysicalDomain[]{p1, p2};
        this.init(ds, ps);
    }

    public Relation(Domain d1, Domain d2, Domain d3, PhysicalDomain p1, PhysicalDomain p2, PhysicalDomain p3) {
        Domain[] ds = new Domain[]{d1, d2, d3};
        PhysicalDomain[] ps = new PhysicalDomain[]{p1, p2, p3};
        this.init(ds, ps);
    }

    public void finalize() {
        JBuddy.bdd_delref(this.bdd);
    }

    public boolean add(Numberable[] tuple) {
        if (tuple.length != this.domains.length) {
            throw new RuntimeException();
        }
        int newBdd = JBuddy.bdd_true();
        for (int i = 0; i < tuple.length; ++i) {
            int num = tuple[i].getNumber();
            int fdd = this.phys[i].ithvar(num);
            int newNewBdd = JBuddy.bdd_and(newBdd, fdd);
            JBuddy.bdd_addref(newNewBdd);
            JBuddy.bdd_delref(newBdd);
            newBdd = newNewBdd;
        }
        int bdd2 = JBuddy.bdd_or(this.bdd, newBdd);
        JBuddy.bdd_addref(bdd2);
        JBuddy.bdd_delref(newBdd);
        if (this.bdd == bdd2) {
            return false;
        }
        JBuddy.bdd_delref(this.bdd);
        this.bdd = bdd2;
        return true;
    }

    public boolean add(Domain d1, Numberable n1) {
        Numberable[] ns = new Numberable[]{n1};
        if (!d1.equals(this.domains[0])) {
            throw new RuntimeException("Trying to add with unknown domain " + d1);
        }
        return this.add(ns);
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(Domain d1, Numberable n1, Domain d2, Numberable n2) {
        void var5_7;
        Numberable[] ns;
        if (d1.equals(this.domains[0]) && d2.equals(this.domains[1])) {
            Numberable[] _;
            ns = _ = new Numberable[]{n1, n2};
        } else if (d1.equals(this.domains[1]) && d2.equals(this.domains[0])) {
            Numberable[] _ = new Numberable[]{n2, n1};
            ns = _;
        } else {
            throw new RuntimeException("Trying to add with domains " + d1 + " and " + d2 + " to relation with domains " + Domain.toString(this.domains));
        }
        return this.add((Numberable[])var5_7);
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(Domain d1, Numberable n1, Domain d2, Numberable n2, Domain d3, Numberable n3) {
        void var7_13;
        Numberable[] ns;
        if (d1.equals(this.domains[0]) && d2.equals(this.domains[1]) && d3.equals(this.domains[2])) {
            Numberable[] _;
            ns = _ = new Numberable[]{n1, n2, n3};
        } else if (d1.equals(this.domains[0]) && d3.equals(this.domains[1]) && d2.equals(this.domains[2])) {
            Numberable[] _ = new Numberable[]{n1, n3, n2};
            ns = _;
        } else if (d3.equals(this.domains[0]) && d1.equals(this.domains[1]) && d2.equals(this.domains[2])) {
            Numberable[] _ = new Numberable[]{n3, n1, n2};
            ns = _;
        } else if (d3.equals(this.domains[0]) && d2.equals(this.domains[1]) && d1.equals(this.domains[2])) {
            Numberable[] _ = new Numberable[]{n3, n2, n1};
            ns = _;
        } else if (d2.equals(this.domains[0]) && d3.equals(this.domains[1]) && d1.equals(this.domains[2])) {
            Numberable[] _ = new Numberable[]{n2, n3, n1};
            ns = _;
        } else if (d1.equals(this.domains[0]) && d3.equals(this.domains[1]) && d2.equals(this.domains[2])) {
            Numberable[] _ = new Numberable[]{n1, n3, n2};
            ns = _;
        } else {
            throw new RuntimeException("Trying to add with domains " + d1 + ", " + d2 + " and " + d3 + " to relation with domains " + Domain.toString(this.domains));
        }
        return this.add((Numberable[])var7_13);
    }

    private int doReplaces(Relation r) {
        int[] newd = new int[r.domains.length];
        int[] oldd = new int[r.domains.length];
        for (int i = 0; i < r.domains.length; ++i) {
            newd[i] = this.phys[this.find(r.domains[i])].var();
            oldd[i] = r.phys[i].var();
        }
        int ret = Relation.replace(r.bdd, oldd, newd);
        return ret;
    }

    public void eq(Relation r) {
        JBuddy.bdd_delref(this.bdd);
        this.bdd = this.doReplaces(r);
        JBuddy.bdd_addref(this.bdd);
    }

    private void eqOp(Relation r1, Relation r2, int op) {
        JBuddy.bdd_delref(this.bdd);
        int bdd1 = this.doReplaces(r1);
        JBuddy.bdd_addref(bdd1);
        int bdd2 = this.doReplaces(r2);
        this.bdd = JBuddy.bdd_apply(bdd1, bdd2, op);
        JBuddy.bdd_addref(this.bdd);
        JBuddy.bdd_delref(bdd1);
    }

    public void eqUnion(Relation r1, Relation r2) {
        JBuddyProfiler.v().start("union", r1.bdd, r2.bdd);
        this.eqOp(r1, r2, JBuddy.bddop_or);
        JBuddyProfiler.v().finish("union", this.bdd);
    }

    public void eqMinus(Relation r1, Relation r2) {
        JBuddyProfiler.v().start("minus", r1.bdd, r2.bdd);
        this.eqOp(r1, r2, JBuddy.bddop_diff);
        JBuddyProfiler.v().finish("minus", this.bdd);
    }

    public void eqIntersect(Relation r1, Relation r2) {
        JBuddyProfiler.v().start("intersect", r1.bdd, r2.bdd);
        this.eqOp(r1, r2, JBuddy.bddop_and);
        JBuddyProfiler.v().finish("intersect", this.bdd);
    }

    public Relation restrict(Domain d, Numberable value) {
        return this.restrict(d, value.getNumber());
    }

    private int find(Domain d) {
        for (int i = 0; i < this.domains.length; ++i) {
            if (!d.equals(this.domains[i])) continue;
            return i;
        }
        throw new RuntimeException("bad domain " + d);
    }

    private Relation restrict(Domain d, int value) {
        Relation result = new Relation(this.domains, this.phys);
        result.bdd = JBuddy.bdd_and(this.bdd, this.phys[this.find(d)].ithvar(value));
        JBuddy.bdd_addref(result.bdd);
        return result;
    }

    public Relation project(Domain remove) {
        Domain[] resdomains = new Domain[this.domains.length - 1];
        PhysicalDomain[] resphys = new PhysicalDomain[this.domains.length - 1];
        int j = 0;
        for (int i = 0; i < this.domains.length; ++i) {
            if (this.domains[i].equals(remove)) continue;
            resdomains[j] = this.domains[i];
            resphys[j] = this.phys[i];
            ++j;
        }
        Relation result = new Relation(resdomains, resphys);
        result.bdd = JBuddy.bdd_exist(this.bdd, JBuddy.fdd_ithset(this.phys[this.find(remove)].var()));
        JBuddy.bdd_addref(result.bdd);
        return result;
    }

    public Relation projectDownTo(Domain remaining) {
        Domain[] resdomains = new Domain[]{remaining};
        PhysicalDomain[] resphys = new PhysicalDomain[]{this.phys[this.find(remaining)]};
        Relation result = new Relation(resdomains, resphys);
        result.bdd = this.bdd;
        JBuddy.bdd_addref(result.bdd);
        for (int i = 0; i < this.domains.length; ++i) {
            if (this.domains[i].equals(remaining)) continue;
            int newBdd = JBuddy.bdd_exist(result.bdd, JBuddy.fdd_ithset(this.phys[i].var()));
            JBuddy.bdd_delref(result.bdd);
            JBuddy.bdd_addref(newBdd);
            result.bdd = newBdd;
        }
        return result;
    }

    public static int relprod(int a, int b, int var) {
        return JBuddy.bdd_appex(a, b, JBuddy.bddop_and, var);
    }

    private static int replace(int bdd, int[] oldd, int[] newd) {
        boolean didSomething = false;
        bddPair pair = JBuddy.bdd_newpair();
        for (int i = 0; i < oldd.length; ++i) {
            if (oldd[i] == newd[i]) continue;
            JBuddy.fdd_setpair(pair, oldd[i], newd[i]);
            didSomething = true;
        }
        if (!didSomething) {
            return bdd;
        }
        JBuddyProfiler.v().start("replace", bdd);
        bdd = JBuddy.bdd_replace(bdd, pair);
        JBuddyProfiler.v().finish("replace", bdd);
        return bdd;
    }

    private static boolean in(Object o, Object[] ar) {
        for (int i = 0; i < ar.length; ++i) {
            if (!ar[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public void eqRelprod(Relation r1, Domain[] eq1, Relation r2, Domain[] eq2, Domain[] result, Relation[] base, Domain[] dom) {
        int i;
        if (eq1.length != eq2.length) {
            throw new RuntimeException();
        }
        if (result.length != base.length) {
            throw new RuntimeException();
        }
        if (result.length != dom.length) {
            throw new RuntimeException();
        }
        this.checkForDupes(result);
        this.checkForDupes(eq1);
        this.checkForDupes(eq2);
        for (int i2 = 0; i2 < r2.domains.length; ++i2) {
            if (Relation.in(r2.domains[i2], eq2) || !Relation.in(r2.phys[i2], r1.phys)) continue;
            throw new RuntimeException("Attempt to do relprod on " + Domain.toString(r1.phys) + " and " + Domain.toString(r2.phys) + "; " + r2.phys[i2] + " conflicts");
        }
        JBuddy.bdd_delref(this.bdd);
        int bdd1 = r1.bdd;
        int bdd2 = r2.bdd;
        int vars = JBuddy.bdd_true();
        int[] newd = new int[eq1.length];
        int[] oldd = new int[eq1.length];
        for (i = 0; i < eq1.length; ++i) {
            newd[i] = r1.phys[r1.find(eq1[i])].var();
            oldd[i] = r2.phys[r2.find(eq2[i])].var();
            vars = JBuddy.bdd_and(vars, JBuddy.fdd_ithset(newd[i]));
        }
        bdd2 = Relation.replace(bdd2, oldd, newd);
        JBuddy.bdd_addref(bdd2);
        JBuddyProfiler.v().start("relprod", bdd1, bdd2);
        int oldbdd = bdd2;
        this.bdd = Relation.relprod(bdd1, bdd2, vars);
        JBuddy.bdd_addref(this.bdd);
        JBuddy.bdd_delref(oldbdd);
        JBuddyProfiler.v().finish("relprod", this.bdd);
        newd = new int[result.length];
        oldd = new int[result.length];
        for (i = 0; i < result.length; ++i) {
            newd[i] = this.phys[this.find(result[i])].var();
            oldd[i] = base[i].phys[base[i].find(dom[i])].var();
        }
        oldbdd = this.bdd;
        this.bdd = Relation.replace(this.bdd, oldd, newd);
        JBuddy.bdd_addref(this.bdd);
        JBuddy.bdd_delref(oldbdd);
    }

    public void eqRelprod(Relation r1, Domain eq1, Relation r2, Domain eq2, Domain res1, Relation base1, Domain dom1, Domain res2, Relation base2, Domain dom2) {
        Domain[] eqs1 = new Domain[]{eq1};
        Domain[] eqs2 = new Domain[]{eq2};
        Domain[] res = new Domain[]{res1, res2};
        Relation[] bases = new Relation[]{base1, base2};
        Domain[] doms = new Domain[]{dom1, dom2};
        this.eqRelprod(r1, eqs1, r2, eqs2, res, bases, doms);
    }

    public void eqRelprod(Relation r1, Domain eq11, Domain eq12, Relation r2, Domain eq21, Domain eq22, Domain res1, Relation base1, Domain dom1, Domain res2, Relation base2, Domain dom2) {
        Domain[] eqs1 = new Domain[]{eq11, eq12};
        Domain[] eqs2 = new Domain[]{eq21, eq22};
        Domain[] res = new Domain[]{res1, res2};
        Relation[] bases = new Relation[]{base1, base2};
        Domain[] doms = new Domain[]{dom1, dom2};
        this.eqRelprod(r1, eqs1, r2, eqs2, res, bases, doms);
    }

    public void eqRelprod(Relation r1, Domain eq1, Relation r2, Domain eq2, Domain res1, Relation base1, Domain dom1, Domain res2, Relation base2, Domain dom2, Domain res3, Relation base3, Domain dom3) {
        Domain[] eqs1 = new Domain[]{eq1};
        Domain[] eqs2 = new Domain[]{eq2};
        Domain[] res = new Domain[]{res1, res2, res3};
        Relation[] bases = new Relation[]{base1, base2, base3};
        Domain[] doms = new Domain[]{dom1, dom2, dom3};
        this.eqRelprod(r1, eqs1, r2, eqs2, res, bases, doms);
    }

    public long size() {
        int[] sats;
        int confirmsize;
        if (this.domains.length == 0) {
            return 1L;
        }
        int var = this.phys[0].var();
        Relation firstDomain = this.projectDownTo(this.domains[0]);
        int size = JBuddy.fdd_satcount(firstDomain.bdd, var);
        if (size != (confirmsize = JBuddy.fdd_allsat(firstDomain.bdd, var, sats = new int[size]))) {
            String sizes = "size: " + size + " confirmsize: " + confirmsize;
            JBuddy.bdd_printset(firstDomain.bdd);
            throw new RuntimeException(sizes);
        }
        long ret = 0L;
        for (int i = 0; i < sats.length; ++i) {
            ret += this.restrict(this.domains[0], sats[i]).project(this.domains[0]).size();
        }
        return ret;
    }

    private void toString(String prefix, StringBuffer b) {
        int[] sats;
        int confirmsize;
        if (this.domains.length == 0) {
            b.append(prefix + "\n");
            return;
        }
        int var = this.phys[0].var();
        Relation firstDomain = this.projectDownTo(this.domains[0]);
        int size = JBuddy.fdd_satcount(firstDomain.bdd, var);
        if (size != (confirmsize = JBuddy.fdd_allsat(firstDomain.bdd, var, sats = new int[size]))) {
            String sizes = "size: " + size + " confirmsize: " + confirmsize;
            JBuddy.bdd_printset(firstDomain.bdd);
            throw new RuntimeException(sizes);
        }
        for (int i = 0; i < sats.length; ++i) {
            this.restrict(this.domains[0], sats[i]).project(this.domains[0]).toString(prefix + this.domains[0].numberer().get(sats[i]) + (this.domains.length > 1 ? ", " : "]"), b);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        this.toString("[", b);
        return b.toString();
    }

    public Relation cloneRelation() {
        Relation ret = this.sameDomains();
        ret.bdd = this.bdd;
        JBuddy.bdd_addref(this.bdd);
        return ret;
    }

    public Relation sameDomains() {
        Domain[] newDomains = new Domain[this.domains.length];
        System.arraycopy(this.domains, 0, newDomains, 0, this.domains.length);
        PhysicalDomain[] newPhys = new PhysicalDomain[this.domains.length];
        System.arraycopy(this.phys, 0, newPhys, 0, this.domains.length);
        return new Relation(newDomains, newPhys);
    }

    public boolean isEmpty() {
        return this.bdd == JBuddy.bdd_false();
    }

    public Iterator iterator() {
        if (this.domains.length != 1) {
            throw new RuntimeException("Can only get iterator over single-column relation");
        }
        int size = JBuddy.fdd_satcount(this.bdd, this.phys[0].var());
        int[] sats = new int[size];
        int confirmsize = JBuddy.fdd_allsat(this.bdd, this.phys[0].var(), sats);
        return new RelationIterator(sats, this.domains[0].numberer());
    }

    public void makeEmpty() {
        JBuddy.bdd_delref(this.bdd);
        this.bdd = JBuddy.bdd_false();
    }

    public void makeFull() {
        JBuddy.bdd_delref(this.bdd);
        this.bdd = JBuddy.bdd_true();
    }

    public boolean isFull() {
        return this.bdd == JBuddy.bdd_true();
    }

    class RelationIterator
    implements Iterator {
        int[] sats;
        Numberer numberer;
        int cur = 0;

        RelationIterator(int[] sats, Numberer numberer) {
            this.sats = sats;
            this.numberer = numberer;
        }

        public final boolean hasNext() {
            return this.cur < this.sats.length;
        }

        public void remove() {
            throw new RuntimeException("Not implemented.");
        }

        public final Object next() {
            return this.numberer.get(this.sats[this.cur++]);
        }
    }
}

