/*
 * Decompiled with CFR 0.152.
 */
package soot.relations;

import java.util.ArrayList;
import java.util.Iterator;
import soot.jbuddy.JBuddy;

public class PhysicalDomain {
    private int bits;
    private int var;
    private String name;

    public PhysicalDomain(int bits) {
        this.bits = bits;
        int[] sizes = new int[]{1 << bits};
        this.var = JBuddy.fdd_extdomain(sizes, 1);
    }

    public PhysicalDomain(int bits, String name) {
        this(bits);
        this.name = name;
    }

    public int bits() {
        return this.bits;
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    public int var() {
        return this.var;
    }

    public int ithvar(int value) {
        return JBuddy.fdd_ithvar(this.var, value);
    }

    private int[] getvars() {
        int[] ret = new int[JBuddy.fdd_varnum(this.var())];
        JBuddy.fdd_getvars(ret, this.var());
        return ret;
    }

    private static void reverse(int[] a) {
        int i = a.length - 1;
        for (int j = 0; j < i; ++j, --i) {
            int t = a[i];
            a[i] = a[j];
            a[j] = t;
        }
    }

    public static void setOrder(Object[] order, boolean msbAtTop) {
        ArrayList<Integer> newOrder = new ArrayList<Integer>();
        for (int i = 0; i < order.length; ++i) {
            Object vars;
            Object o = order[i];
            if (o instanceof PhysicalDomain) {
                PhysicalDomain pd = (PhysicalDomain)o;
                vars = pd.getvars();
                if (msbAtTop) {
                    PhysicalDomain.reverse(vars);
                }
                for (int k = 0; k < ((int[])vars).length; ++k) {
                    newOrder.add(new Integer(vars[k]));
                }
                continue;
            }
            if (o instanceof Object[]) {
                PhysicalDomain[] domains = (PhysicalDomain[])o;
                vars = new int[domains.length][];
                for (int j = 0; j < domains.length; ++j) {
                    vars[j] = (int)domains[j].getvars();
                    if (!msbAtTop) continue;
                    PhysicalDomain.reverse((int[])vars[j]);
                }
                boolean change = true;
                int j = 0;
                while (change) {
                    change = false;
                    for (int k = 0; k < ((int[])vars).length; ++k) {
                        if (j >= ((int)vars[k]).length) continue;
                        newOrder.add(new Integer((int)vars[k][j]));
                        change = true;
                    }
                    ++j;
                }
                continue;
            }
            throw new RuntimeException();
        }
        int[] buddyOrder = new int[newOrder.size()];
        int j = 0;
        Iterator iIt = newOrder.iterator();
        while (iIt.hasNext()) {
            Integer i = (Integer)iIt.next();
            buddyOrder[j++] = i;
        }
        JBuddy.bdd_setvarorder(buddyOrder);
    }

    static {
        System.loadLibrary("jbuddy");
        JBuddy.bdd_init(1000000, 100000);
    }
}

