/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.integer;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import soot.jimple.toolkits.typing.integer.TypeException;
import soot.jimple.toolkits.typing.integer.TypeNode;
import soot.jimple.toolkits.typing.integer.TypeResolver;

class TypeVariable
implements Comparable {
    private static final boolean DEBUG = false;
    private final int id;
    private final TypeResolver resolver;
    private TypeVariable rep = this;
    private int rank = 0;
    private TypeNode approx;
    private TypeNode inv_approx;
    private TypeNode type;
    private List parents = Collections.unmodifiableList(new LinkedList());
    private List children = Collections.unmodifiableList(new LinkedList());

    public TypeVariable(int id, TypeResolver resolver) {
        this.id = id;
        this.resolver = resolver;
    }

    public TypeVariable(int id, TypeResolver resolver, TypeNode type) {
        this.id = id;
        this.resolver = resolver;
        this.type = type;
        this.approx = type;
        this.inv_approx = type;
    }

    public int hashCode() {
        if (this.rep != this) {
            return this.ecr().hashCode();
        }
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this.rep != this) {
            return this.ecr().equals(obj);
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TypeVariable ecr = ((TypeVariable)obj).ecr();
        return ecr == this;
    }

    public int compareTo(Object o) {
        if (this.rep != this) {
            return this.ecr().compareTo(o);
        }
        return this.id - ((TypeVariable)o).ecr().id;
    }

    private TypeVariable ecr() {
        if (this.rep != this) {
            this.rep = this.rep.ecr();
        }
        return this.rep;
    }

    public TypeVariable union(TypeVariable var) throws TypeException {
        if (this.rep != this) {
            return this.ecr().union(var);
        }
        TypeVariable y = var.ecr();
        if (this == y) {
            return this;
        }
        if (this.rank > y.rank) {
            y.rep = this;
            this.merge(y);
            y.clear();
            return this;
        }
        this.rep = y;
        if (this.rank == y.rank) {
            ++y.rank;
        }
        y.merge(this);
        this.clear();
        return y;
    }

    private void clear() {
        this.inv_approx = null;
        this.approx = null;
        this.type = null;
        this.parents = null;
        this.children = null;
    }

    private void merge(TypeVariable var) throws TypeException {
        if (this.type == null) {
            this.type = var.type;
        } else if (var.type != null) {
            TypeVariable.error("Type Error(22): Attempt to merge two types.");
        }
        TreeSet set = new TreeSet(this.parents);
        set.addAll(var.parents);
        set.remove(this);
        this.parents = Collections.unmodifiableList(new LinkedList(set));
        set = new TreeSet(this.children);
        set.addAll(var.children);
        set.remove(this);
        this.children = Collections.unmodifiableList(new LinkedList(set));
    }

    public int id() {
        if (this.rep != this) {
            return this.ecr().id();
        }
        return this.id;
    }

    public void addParent(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().addParent(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        if (var == this) {
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.parents);
        set.add(var);
        this.parents = Collections.unmodifiableList(new LinkedList(set));
        set = new TreeSet(var.children);
        set.add(this);
        var.children = Collections.unmodifiableList(new LinkedList(set));
    }

    public void removeParent(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().removeParent(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        TreeSet set = new TreeSet(this.parents);
        set.remove(var);
        this.parents = Collections.unmodifiableList(new LinkedList(set));
        set = new TreeSet(var.children);
        set.remove(this);
        var.children = Collections.unmodifiableList(new LinkedList(set));
    }

    public void addChild(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().addChild(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        if (var == this) {
            return;
        }
        TreeSet<TypeVariable> set = new TreeSet<TypeVariable>(this.children);
        set.add(var);
        this.children = Collections.unmodifiableList(new LinkedList(set));
        set = new TreeSet(var.parents);
        set.add(this);
        var.parents = Collections.unmodifiableList(new LinkedList(set));
    }

    public void removeChild(TypeVariable variable) {
        if (this.rep != this) {
            this.ecr().removeChild(variable);
            return;
        }
        TypeVariable var = variable.ecr();
        TreeSet set = new TreeSet(this.children);
        set.remove(var);
        this.children = Collections.unmodifiableList(new LinkedList(set));
        set = new TreeSet(var.parents);
        set.remove(this);
        var.parents = Collections.unmodifiableList(new LinkedList(set));
    }

    public List parents() {
        if (this.rep != this) {
            return this.ecr().parents();
        }
        return this.parents;
    }

    public List children() {
        if (this.rep != this) {
            return this.ecr().children();
        }
        return this.children;
    }

    public TypeNode approx() {
        if (this.rep != this) {
            return this.ecr().approx();
        }
        return this.approx;
    }

    public TypeNode inv_approx() {
        if (this.rep != this) {
            return this.ecr().inv_approx();
        }
        return this.inv_approx;
    }

    public TypeNode type() {
        if (this.rep != this) {
            return this.ecr().type();
        }
        return this.type;
    }

    static void error(String message) throws TypeException {
        throw new TypeException(message);
    }

    public static void computeApprox(TreeSet workList) throws TypeException {
        while (workList.size() > 0) {
            TypeVariable var = (TypeVariable)workList.first();
            workList.remove(var);
            var.fixApprox(workList);
        }
    }

    public static void computeInvApprox(TreeSet workList) throws TypeException {
        while (workList.size() > 0) {
            TypeVariable var = (TypeVariable)workList.first();
            workList.remove(var);
            var.fixInvApprox(workList);
        }
    }

    private void fixApprox(TreeSet workList) throws TypeException {
        if (this.rep != this) {
            this.ecr().fixApprox(workList);
            return;
        }
        Iterator i = this.parents.iterator();
        while (i.hasNext()) {
            TypeVariable parent = ((TypeVariable)i.next()).ecr();
            if (parent.approx == null) {
                parent.approx = this.approx;
                workList.add(parent);
                continue;
            }
            TypeNode type = parent.approx.lca_2(this.approx);
            if (type == parent.approx) continue;
            parent.approx = type;
            workList.add(parent);
        }
        if (this.type != null) {
            this.approx = this.type;
        }
    }

    private void fixInvApprox(TreeSet workList) throws TypeException {
        if (this.rep != this) {
            this.ecr().fixInvApprox(workList);
            return;
        }
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            TypeVariable child = ((TypeVariable)i.next()).ecr();
            if (child.inv_approx == null) {
                child.inv_approx = this.inv_approx;
                workList.add(child);
                continue;
            }
            TypeNode type = child.inv_approx.gcd_2(this.inv_approx);
            if (type == child.inv_approx) continue;
            child.inv_approx = type;
            workList.add(child);
        }
        if (this.type != null) {
            this.inv_approx = this.type;
        }
    }

    public String toString() {
        if (this.rep != this) {
            return this.ecr().toString();
        }
        StringBuffer s = new StringBuffer();
        s.append(",[parents:");
        boolean comma = false;
        Iterator i = this.parents.iterator();
        while (i.hasNext()) {
            if (comma) {
                s.append(",");
            } else {
                comma = true;
            }
            s.append(((TypeVariable)i.next()).id());
        }
        s.append("],[children:");
        comma = false;
        i = this.children.iterator();
        while (i.hasNext()) {
            if (comma) {
                s.append(",");
            } else {
                comma = true;
            }
            s.append(((TypeVariable)i.next()).id());
        }
        s.append("]");
        return "[id:" + this.id + (this.type != null ? ",type:" + this.type : "") + ",approx:" + this.approx + ",inv_approx:" + this.inv_approx + s + "]";
    }

    public void fixParents() {
        if (this.rep != this) {
            this.ecr().fixParents();
            return;
        }
        TreeSet set = new TreeSet(this.parents);
        this.parents = Collections.unmodifiableList(new LinkedList(set));
    }

    public void fixChildren() {
        if (this.rep != this) {
            this.ecr().fixChildren();
            return;
        }
        TreeSet set = new TreeSet(this.children);
        this.children = Collections.unmodifiableList(new LinkedList(set));
    }
}

