/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.integer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import soot.BooleanType;
import soot.ByteType;
import soot.IntegerType;
import soot.Local;
import soot.PatchingChain;
import soot.ShortType;
import soot.Type;
import soot.jimple.JimpleBody;
import soot.jimple.Stmt;
import soot.jimple.toolkits.typing.integer.ClassHierarchy;
import soot.jimple.toolkits.typing.integer.ConstraintChecker;
import soot.jimple.toolkits.typing.integer.ConstraintCollector;
import soot.jimple.toolkits.typing.integer.StronglyConnectedComponents;
import soot.jimple.toolkits.typing.integer.TypeException;
import soot.jimple.toolkits.typing.integer.TypeNode;
import soot.jimple.toolkits.typing.integer.TypeVariable;

public class TypeResolver {
    private final List typeVariableList = new ArrayList();
    private final Map typeVariableMap = new HashMap();
    private final JimpleBody stmtBody;
    final TypeVariable BOOLEAN;
    final TypeVariable BYTE;
    final TypeVariable SHORT;
    final TypeVariable CHAR;
    final TypeVariable INT;
    final TypeVariable TOP;
    final TypeVariable R0_1;
    final TypeVariable R0_127;
    final TypeVariable R0_32767;
    private static final boolean DEBUG = false;
    private List unsolved;
    private List solved;

    TypeVariable typeVariable(Local local) {
        TypeVariable result = (TypeVariable)this.typeVariableMap.get(local);
        if (result == null) {
            int id = this.typeVariableList.size();
            this.typeVariableList.add(null);
            result = new TypeVariable(id, this);
            this.typeVariableList.set(id, result);
            this.typeVariableMap.put(local, result);
        }
        return result;
    }

    public TypeVariable typeVariable(TypeNode typeNode) {
        TypeVariable result = (TypeVariable)this.typeVariableMap.get(typeNode);
        if (result == null) {
            int id = this.typeVariableList.size();
            this.typeVariableList.add(null);
            result = new TypeVariable(id, this, typeNode);
            this.typeVariableList.set(id, result);
            this.typeVariableMap.put(typeNode, result);
        }
        return result;
    }

    public TypeVariable typeVariable(Type type) {
        return this.typeVariable(ClassHierarchy.v().typeNode(type));
    }

    public TypeVariable typeVariable() {
        int id = this.typeVariableList.size();
        this.typeVariableList.add(null);
        TypeVariable result = new TypeVariable(id, this);
        this.typeVariableList.set(id, result);
        return result;
    }

    private TypeResolver(JimpleBody stmtBody) {
        this.BOOLEAN = this.typeVariable(ClassHierarchy.v().BOOLEAN);
        this.BYTE = this.typeVariable(ClassHierarchy.v().BYTE);
        this.SHORT = this.typeVariable(ClassHierarchy.v().SHORT);
        this.CHAR = this.typeVariable(ClassHierarchy.v().CHAR);
        this.INT = this.typeVariable(ClassHierarchy.v().INT);
        this.TOP = this.typeVariable(ClassHierarchy.v().TOP);
        this.R0_1 = this.typeVariable(ClassHierarchy.v().R0_1);
        this.R0_127 = this.typeVariable(ClassHierarchy.v().R0_127);
        this.R0_32767 = this.typeVariable(ClassHierarchy.v().R0_32767);
        this.stmtBody = stmtBody;
    }

    public static void resolve(JimpleBody stmtBody) {
        try {
            TypeResolver resolver = new TypeResolver(stmtBody);
            resolver.resolve_step_1();
        }
        catch (TypeException e1) {
            try {
                TypeResolver resolver = new TypeResolver(stmtBody);
                resolver.resolve_step_2();
            }
            catch (TypeException e2) {
                StringWriter st = new StringWriter();
                PrintWriter pw = new PrintWriter(st);
                e2.printStackTrace(pw);
                pw.close();
                throw new RuntimeException(st.toString());
            }
        }
    }

    private void debug_vars(String message) {
    }

    private void debug_body() {
    }

    private void resolve_step_1() throws TypeException {
        this.collect_constraints_1();
        this.debug_vars("constraints");
        this.compute_approximate_types();
        this.merge_connected_components();
        this.debug_vars("components");
        this.merge_single_constraints();
        this.debug_vars("single");
        this.assign_types_1();
        this.debug_vars("assign");
        try {
            this.check_constraints();
        }
        catch (TypeException e) {
            this.check_and_fix_constraints();
        }
    }

    private void resolve_step_2() throws TypeException {
        this.collect_constraints_2();
        this.compute_approximate_types();
        this.assign_types_2();
        this.check_and_fix_constraints();
    }

    private void collect_constraints_1() {
        ConstraintCollector collector = new ConstraintCollector(this, true);
        Iterator stmtIt = this.stmtBody.getUnits().iterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            collector.collect(stmt, this.stmtBody);
        }
    }

    private void collect_constraints_2() {
        ConstraintCollector collector = new ConstraintCollector(this, false);
        Iterator stmtIt = this.stmtBody.getUnits().iterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            collector.collect(stmt, this.stmtBody);
        }
    }

    private void merge_connected_components() throws TypeException {
        this.compute_solved();
        LinkedList list = new LinkedList();
        list.addAll(this.solved);
        list.addAll(this.unsolved);
        StronglyConnectedComponents.merge(list);
    }

    private void merge_single_constraints() throws TypeException {
        boolean modified = true;
        while (modified) {
            TypeNode type;
            TypeNode type2;
            TypeVariable var;
            modified = false;
            this.refresh_solved();
            Iterator varIt = this.unsolved.iterator();
            while (varIt.hasNext()) {
                TypeVariable child;
                TypeVariable child2;
                var = (TypeVariable)varIt.next();
                LinkedList<TypeVariable> children_to_remove = new LinkedList<TypeVariable>();
                TypeNode lca = null;
                var.fixChildren();
                Iterator childIt = var.children().iterator();
                while (childIt.hasNext()) {
                    child2 = (TypeVariable)childIt.next();
                    type2 = child2.type();
                    if (type2 == null) continue;
                    children_to_remove.add(child2);
                    if (lca == null) {
                        lca = type2;
                        continue;
                    }
                    lca = lca.lca_1(type2);
                }
                if (lca != null) {
                    childIt = children_to_remove.iterator();
                    while (childIt.hasNext()) {
                        child2 = (TypeVariable)childIt.next();
                        var.removeChild(child2);
                    }
                    var.addChild(this.typeVariable(lca));
                }
                if (var.children().size() != 1 || (type = (child = (TypeVariable)var.children().get(0)).type()) != null && type.type() == null) continue;
                var.union(child);
                modified = true;
            }
            if (!modified) {
                varIt = this.unsolved.iterator();
                while (varIt.hasNext()) {
                    TypeVariable parent;
                    TypeVariable parent2;
                    var = (TypeVariable)varIt.next();
                    LinkedList<TypeVariable> parents_to_remove = new LinkedList<TypeVariable>();
                    TypeNode gcd = null;
                    var.fixParents();
                    Iterator parentIt = var.parents().iterator();
                    while (parentIt.hasNext()) {
                        parent2 = (TypeVariable)parentIt.next();
                        type2 = parent2.type();
                        if (type2 == null) continue;
                        parents_to_remove.add(parent2);
                        if (gcd == null) {
                            gcd = type2;
                            continue;
                        }
                        gcd = gcd.gcd_1(type2);
                    }
                    if (gcd != null) {
                        parentIt = parents_to_remove.iterator();
                        while (parentIt.hasNext()) {
                            parent2 = (TypeVariable)parentIt.next();
                            var.removeParent(parent2);
                        }
                        var.addParent(this.typeVariable(gcd));
                    }
                    if (var.parents().size() != 1 || (type = (parent = (TypeVariable)var.parents().get(0)).type()) != null && type.type() == null) continue;
                    var.union(parent);
                    modified = true;
                }
            }
            if (!modified) {
                varIt = this.unsolved.iterator();
                while (varIt.hasNext()) {
                    var = (TypeVariable)varIt.next();
                    if (var.type() != null || var.inv_approx() == null || var.inv_approx().type() == null) continue;
                    var.union(this.typeVariable(var.inv_approx()));
                    modified = true;
                }
            }
            if (!modified) {
                varIt = this.unsolved.iterator();
                while (varIt.hasNext()) {
                    var = (TypeVariable)varIt.next();
                    if (var.type() != null || var.approx() == null || var.approx().type() == null) continue;
                    var.union(this.typeVariable(var.approx()));
                    modified = true;
                }
            }
            if (!modified) {
                varIt = this.unsolved.iterator();
                while (varIt.hasNext()) {
                    var = (TypeVariable)varIt.next();
                    if (var.type() != null || var.approx() != ClassHierarchy.v().R0_32767) continue;
                    var.union(this.SHORT);
                    modified = true;
                }
            }
            if (!modified) {
                varIt = this.unsolved.iterator();
                while (varIt.hasNext()) {
                    var = (TypeVariable)varIt.next();
                    if (var.type() != null || var.approx() != ClassHierarchy.v().R0_127) continue;
                    var.union(this.BYTE);
                    modified = true;
                }
            }
            if (modified) continue;
            varIt = this.R0_1.parents().iterator();
            while (varIt.hasNext()) {
                var = (TypeVariable)varIt.next();
                if (var.type() != null || var.approx() != ClassHierarchy.v().R0_1) continue;
                var.union(this.BOOLEAN);
                modified = true;
            }
        }
    }

    private void assign_types_1() throws TypeException {
        Iterator localIt = this.stmtBody.getLocals().iterator();
        while (localIt.hasNext()) {
            Local local = (Local)localIt.next();
            if (!(local.getType() instanceof IntegerType)) continue;
            TypeVariable var = this.typeVariable(local);
            if (var.type() == null || var.type().type() == null) {
                TypeVariable.error("Type Error(21):  Variable without type");
                continue;
            }
            local.setType(var.type().type());
        }
    }

    private void assign_types_2() throws TypeException {
        Iterator localIt = this.stmtBody.getLocals().iterator();
        while (localIt.hasNext()) {
            Local local = (Local)localIt.next();
            if (!(local.getType() instanceof IntegerType)) continue;
            TypeVariable var = this.typeVariable(local);
            if (var.inv_approx() != null && var.inv_approx().type() != null) {
                local.setType(var.inv_approx().type());
                continue;
            }
            if (var.approx().type() != null) {
                local.setType(var.approx().type());
                continue;
            }
            if (var.approx() == ClassHierarchy.v().R0_1) {
                local.setType(BooleanType.v());
                continue;
            }
            if (var.approx() == ClassHierarchy.v().R0_127) {
                local.setType(ByteType.v());
                continue;
            }
            local.setType(ShortType.v());
        }
    }

    private void check_constraints() throws TypeException {
        ConstraintChecker checker = new ConstraintChecker(this, false);
        Object s = null;
        Iterator stmtIt = this.stmtBody.getUnits().iterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            checker.check(stmt, this.stmtBody);
        }
    }

    private void check_and_fix_constraints() throws TypeException {
        ConstraintChecker checker = new ConstraintChecker(this, true);
        Object s = null;
        PatchingChain units = this.stmtBody.getUnits();
        Stmt[] stmts = new Stmt[units.size()];
        units.toArray(stmts);
        for (int i = 0; i < stmts.length; ++i) {
            Stmt stmt = stmts[i];
            checker.check(stmt, this.stmtBody);
            continue;
        }
    }

    private void compute_approximate_types() throws TypeException {
        TypeVariable var;
        TreeSet<TypeVariable> workList = new TreeSet<TypeVariable>();
        Iterator varIt = this.typeVariableList.iterator();
        while (varIt.hasNext()) {
            var = (TypeVariable)varIt.next();
            if (var.type() == null) continue;
            workList.add(var);
        }
        TypeVariable.computeApprox(workList);
        workList = new TreeSet();
        varIt = this.typeVariableList.iterator();
        while (varIt.hasNext()) {
            var = (TypeVariable)varIt.next();
            if (var.type() == null) continue;
            workList.add(var);
        }
        TypeVariable.computeInvApprox(workList);
        varIt = this.typeVariableList.iterator();
        while (varIt.hasNext()) {
            var = (TypeVariable)varIt.next();
            if (var.approx() != null) continue;
            var.union(this.INT);
        }
    }

    private void compute_solved() {
        TreeSet<TypeVariable> unsolved_set = new TreeSet<TypeVariable>();
        TreeSet<TypeVariable> solved_set = new TreeSet<TypeVariable>();
        Iterator varIt = this.typeVariableList.iterator();
        while (varIt.hasNext()) {
            TypeVariable var = (TypeVariable)varIt.next();
            if (var.type() == null) {
                unsolved_set.add(var);
                continue;
            }
            solved_set.add(var);
        }
        this.solved = new LinkedList(solved_set);
        this.unsolved = new LinkedList(unsolved_set);
    }

    private void refresh_solved() throws TypeException {
        TreeSet<TypeVariable> unsolved_set = new TreeSet<TypeVariable>();
        TreeSet<TypeVariable> solved_set = new TreeSet<TypeVariable>(this.solved);
        Iterator varIt = this.unsolved.iterator();
        while (varIt.hasNext()) {
            TypeVariable var = (TypeVariable)varIt.next();
            if (var.type() == null) {
                unsolved_set.add(var);
                continue;
            }
            solved_set.add(var);
        }
        this.solved = new LinkedList(solved_set);
        this.unsolved = new LinkedList(unsolved_set);
    }
}

