/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.SideEffectTester;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.NaiveSideEffectTester;
import soot.jimple.toolkits.graph.CriticalEdgeRemover;
import soot.jimple.toolkits.graph.LoopConditionUnroller;
import soot.jimple.toolkits.pointer.PASideEffectTester;
import soot.jimple.toolkits.scalar.LocalCreation;
import soot.jimple.toolkits.scalar.pre.DelayabilityAnalysis;
import soot.jimple.toolkits.scalar.pre.DownSafetyAnalysis;
import soot.jimple.toolkits.scalar.pre.EarliestnessComputation;
import soot.jimple.toolkits.scalar.pre.LatestComputation;
import soot.jimple.toolkits.scalar.pre.NotIsolatedAnalysis;
import soot.jimple.toolkits.scalar.pre.SootFilter;
import soot.jimple.toolkits.scalar.pre.UpSafetyAnalysis;
import soot.options.LCMOptions;
import soot.options.Options;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.util.UnitMap;

public class LazyCodeMotion
extends BodyTransformer {
    private static final String PREFIX = "$lcm";

    public LazyCodeMotion(Singletons.Global g) {
    }

    public static LazyCodeMotion v() {
        return G.v().LazyCodeMotion();
    }

    protected void internalTransform(Body b, String phaseName, Map opts) {
        Unit currentUnit;
        DownSafetyAnalysis downSafe;
        LCMOptions options = new LCMOptions(opts);
        HashMap<EquivalentValue, Local> expToHelper = new HashMap<EquivalentValue, Local>();
        PatchingChain unitChain = b.getUnits();
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "] Performing Lazy Code Motion...");
        }
        if (options.unroll()) {
            new LoopConditionUnroller().transform(b, phaseName + ".lcu");
        }
        CriticalEdgeRemover.v().transform(b, phaseName + ".cer");
        BriefUnitGraph graph = new BriefUnitGraph(b);
        UnitMap unitToEquivRhs = new UnitMap(b, graph.size() + 1, 0.7f){

            protected Object mapTo(Unit unit) {
                Value tmp = SootFilter.noInvokeRhs(unit);
                Value tmp2 = SootFilter.binop(tmp);
                if (tmp2 == null) {
                    tmp2 = SootFilter.concreteRef(tmp);
                }
                return SootFilter.equiVal(tmp2);
            }
        };
        UnitMap unitToNoExceptionEquivRhs = new UnitMap(b, graph.size() + 1, 0.7f){

            protected Object mapTo(Unit unit) {
                Value tmp = SootFilter.binopRhs(unit);
                tmp = SootFilter.noExceptionThrowing(tmp);
                return SootFilter.equiVal(tmp);
            }
        };
        CollectionFlowUniverse universe = new CollectionFlowUniverse(unitToEquivRhs.values());
        ArrayPackedSet set = new ArrayPackedSet(universe);
        SideEffectTester sideEffect = Scene.v().hasCallGraph() && !options.naive_side_effect() ? new PASideEffectTester() : new NaiveSideEffectTester();
        sideEffect.newMethod(b.getMethod());
        UpSafetyAnalysis upSafe = options.safety() == 1 ? new UpSafetyAnalysis(graph, unitToNoExceptionEquivRhs, sideEffect, set) : new UpSafetyAnalysis(graph, unitToEquivRhs, sideEffect, set);
        if (options.safety() == 3) {
            downSafe = new DownSafetyAnalysis(graph, unitToEquivRhs, sideEffect, set);
        } else {
            downSafe = new DownSafetyAnalysis(graph, unitToNoExceptionEquivRhs, sideEffect, set);
            Iterator unitIt = unitChain.iterator();
            while (unitIt.hasNext()) {
                Unit currentUnit2 = (Unit)unitIt.next();
                Object rhs = unitToEquivRhs.get(currentUnit2);
                if (rhs == null) continue;
                ((FlowSet)downSafe.getFlowBefore(currentUnit2)).add(rhs);
            }
        }
        EarliestnessComputation earliest = new EarliestnessComputation(graph, upSafe, downSafe, sideEffect, set);
        DelayabilityAnalysis delay = new DelayabilityAnalysis(graph, earliest, unitToEquivRhs, set);
        LatestComputation latest = new LatestComputation(graph, delay, unitToEquivRhs, set);
        NotIsolatedAnalysis notIsolated = new NotIsolatedAnalysis(graph, latest, unitToEquivRhs, set);
        LocalCreation localCreation = new LocalCreation(b.getLocals(), PREFIX);
        Iterator unitIt = unitChain.snapshotIterator();
        while (unitIt.hasNext()) {
            currentUnit = (Unit)unitIt.next();
            FlowSet latestSet = (FlowSet)latest.getFlowBefore(currentUnit);
            FlowSet notIsolatedSet = (FlowSet)notIsolated.getFlowAfter(currentUnit);
            FlowSet insertHere = (FlowSet)latestSet.clone();
            insertHere.intersection(notIsolatedSet, insertHere);
            Iterator insertIt = insertHere.iterator();
            while (insertIt.hasNext()) {
                EquivalentValue equiVal = (EquivalentValue)insertIt.next();
                Local helper = (Local)expToHelper.get(equiVal);
                if (helper == null) {
                    helper = localCreation.newLocal(equiVal.getType());
                    expToHelper.put(equiVal, helper);
                }
                Value insertValue = Jimple.cloneIfNecessary(equiVal.getValue());
                AssignStmt firstComp = Jimple.v().newAssignStmt(helper, insertValue);
                unitChain.insertBefore(firstComp, (Object)currentUnit);
            }
        }
        unitIt = unitChain.iterator();
        while (unitIt.hasNext()) {
            currentUnit = (Unit)unitIt.next();
            EquivalentValue rhs = (EquivalentValue)unitToEquivRhs.get(currentUnit);
            if (rhs == null) continue;
            FlowSet latestSet = (FlowSet)latest.getFlowBefore(currentUnit);
            FlowSet notIsolatedSet = (FlowSet)notIsolated.getFlowAfter(currentUnit);
            if (latestSet.contains(rhs) || !notIsolatedSet.contains(rhs)) continue;
            Local helper = (Local)expToHelper.get(rhs);
            try {
                ((AssignStmt)currentUnit).setRightOp(helper);
            }
            catch (RuntimeException e) {
                G.v().out.println("Error on " + b.getMethod().getName());
                G.v().out.println(currentUnit.toString());
                G.v().out.println(latestSet);
                G.v().out.println(notIsolatedSet);
                throw e;
            }
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "]     Lazy Code Motion done.");
        }
    }
}

