/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.SideEffectTester;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.NaiveSideEffectTester;
import soot.jimple.toolkits.graph.CriticalEdgeRemover;
import soot.jimple.toolkits.pointer.PASideEffectTester;
import soot.jimple.toolkits.scalar.LocalCreation;
import soot.jimple.toolkits.scalar.pre.DownSafetyAnalysis;
import soot.jimple.toolkits.scalar.pre.EarliestnessComputation;
import soot.jimple.toolkits.scalar.pre.SootFilter;
import soot.jimple.toolkits.scalar.pre.UpSafetyAnalysis;
import soot.options.BCMOptions;
import soot.options.Options;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.util.UnitMap;

public class BusyCodeMotion
extends BodyTransformer {
    private static final String PREFIX = "$bcm";

    public BusyCodeMotion(Singletons.Global g) {
    }

    public static BusyCodeMotion v() {
        return G.v().BusyCodeMotion();
    }

    protected void internalTransform(Body b, String phaseName, Map opts) {
        Unit currentUnit;
        BCMOptions options = new BCMOptions(opts);
        boolean counter = false;
        HashMap<EquivalentValue, Local> expToHelper = new HashMap<EquivalentValue, Local>();
        PatchingChain unitChain = b.getUnits();
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "]     performing Busy Code Motion...");
        }
        CriticalEdgeRemover.v().transform(b, phaseName + ".cer");
        BriefUnitGraph graph = new BriefUnitGraph(b);
        UnitMap unitToEquivRhs = new UnitMap(b, graph.size() + 1, 0.7f){

            protected Object mapTo(Unit unit) {
                Value tmp = SootFilter.noInvokeRhs(unit);
                Value tmp2 = SootFilter.binop(tmp);
                if (tmp2 == null) {
                    tmp2 = SootFilter.concreteRef(tmp);
                }
                return SootFilter.equiVal(tmp2);
            }
        };
        UnitMap unitToNoExceptionEquivRhs = new UnitMap(b, graph.size() + 1, 0.7f){

            protected Object mapTo(Unit unit) {
                Value tmp = SootFilter.binopRhs(unit);
                tmp = SootFilter.noExceptionThrowing(tmp);
                return SootFilter.equiVal(tmp);
            }
        };
        SideEffectTester sideEffect = Scene.v().hasCallGraph() && !options.naive_side_effect() ? new PASideEffectTester() : new NaiveSideEffectTester();
        sideEffect.newMethod(b.getMethod());
        UpSafetyAnalysis upSafe = new UpSafetyAnalysis(graph, unitToEquivRhs, sideEffect);
        DownSafetyAnalysis downSafe = new DownSafetyAnalysis(graph, unitToNoExceptionEquivRhs, sideEffect);
        EarliestnessComputation earliest = new EarliestnessComputation(graph, upSafe, downSafe, sideEffect);
        LocalCreation localCreation = new LocalCreation(b.getLocals(), PREFIX);
        Iterator unitIt = unitChain.snapshotIterator();
        while (unitIt.hasNext()) {
            currentUnit = (Unit)unitIt.next();
            Iterator earliestIt = ((FlowSet)earliest.getFlowBefore(currentUnit)).iterator();
            while (earliestIt.hasNext()) {
                EquivalentValue equiVal = (EquivalentValue)earliestIt.next();
                Value exp = equiVal.getValue();
                Local helper = (Local)expToHelper.get(equiVal);
                if (helper == null) {
                    helper = localCreation.newLocal(equiVal.getType());
                    expToHelper.put(equiVal, helper);
                }
                Value insertValue = Jimple.cloneIfNecessary(equiVal.getValue());
                AssignStmt firstComp = Jimple.v().newAssignStmt(helper, insertValue);
                unitChain.insertBefore(firstComp, (Object)currentUnit);
            }
        }
        unitIt = unitChain.iterator();
        while (unitIt.hasNext()) {
            Local helper;
            currentUnit = (Unit)unitIt.next();
            EquivalentValue rhs = (EquivalentValue)unitToEquivRhs.get(currentUnit);
            if (rhs == null || (helper = (Local)expToHelper.get(rhs)) == null) continue;
            ((AssignStmt)currentUnit).setRightOp(helper);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "]     Busy Code Motion done!");
        }
    }
}

