/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.EquivalentValue;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Expr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.Stmt;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayFlowUniverse;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.Chain;
import soot.util.HashChain;

class SlowAvailableExpressionsAnalysis
extends ForwardFlowAnalysis {
    Map unitToGenerateSet;
    Map unitToPreserveSet;
    Map rhsToContainingStmt;
    private HashMap valueToEquivValue;
    FlowSet emptySet;

    public SlowAvailableExpressionsAnalysis(DirectedGraph dg) {
        super(dg);
        UnitGraph g = (UnitGraph)dg;
        Iterator unitsIt = g.getBody().getUnits().iterator();
        ArrayList<Value> exprs = new ArrayList<Value>();
        HashMap<EquivalentValue, HashChain> containingExprs = new HashMap<EquivalentValue, HashChain>();
        this.valueToEquivValue = new HashMap();
        this.rhsToContainingStmt = new HashMap();
        HashMap<EquivalentValue, Chain> equivValToSiblingList = new HashMap<EquivalentValue, Chain>();
        while (unitsIt.hasNext()) {
            Stmt s = (Stmt)unitsIt.next();
            if (!(s instanceof AssignStmt)) continue;
            Value v = ((AssignStmt)s).getRightOp();
            this.rhsToContainingStmt.put(v, s);
            EquivalentValue ev = (EquivalentValue)this.valueToEquivValue.get(v);
            if (ev == null) {
                ev = new EquivalentValue(v);
                this.valueToEquivValue.put(v, ev);
            }
            Chain sibList = null;
            if (equivValToSiblingList.get(ev) == null) {
                sibList = new HashChain();
                equivValToSiblingList.put(ev, sibList);
            } else {
                sibList = (Chain)equivValToSiblingList.get(ev);
            }
            if (!sibList.contains(v)) {
                sibList.add(v);
            }
            if (!(v instanceof Expr) || exprs.contains(v)) continue;
            exprs.add(v);
            Iterator it = v.getUseBoxes().iterator();
            while (it.hasNext()) {
                Value o = ((ValueBox)it.next()).getValue();
                EquivalentValue eo = (EquivalentValue)this.valueToEquivValue.get(o);
                if (eo == null) {
                    eo = new EquivalentValue(o);
                    this.valueToEquivValue.put(o, eo);
                }
                if (equivValToSiblingList.get(eo) == null) {
                    sibList = new HashChain();
                    equivValToSiblingList.put(eo, sibList);
                } else {
                    sibList = (Chain)equivValToSiblingList.get(eo);
                }
                if (!sibList.contains(o)) {
                    sibList.add(o);
                }
                HashChain l = null;
                if (containingExprs.containsKey(eo)) {
                    l = (HashChain)containingExprs.get(eo);
                } else {
                    l = new HashChain();
                    containingExprs.put(eo, l);
                }
                if (l.contains(ev)) continue;
                l.add(ev);
            }
        }
        ArrayFlowUniverse exprUniv = new ArrayFlowUniverse(exprs.toArray());
        this.emptySet = new ArrayPackedSet(exprUniv);
        this.unitToPreserveSet = new HashMap(g.size() * 2 + 1, 0.7f);
        Iterator unitIt = g.iterator();
        while (unitIt.hasNext()) {
            ArrayPackedSet killSet = new ArrayPackedSet(exprUniv);
            Unit s = (Unit)unitIt.next();
            Iterator boxIt = s.getDefBoxes().iterator();
            while (boxIt.hasNext()) {
                ValueBox box = (ValueBox)boxIt.next();
                Value v = box.getValue();
                EquivalentValue ev = (EquivalentValue)this.valueToEquivValue.get(v);
                HashChain c = (HashChain)containingExprs.get(ev);
                if (c == null) continue;
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    EquivalentValue container2 = (EquivalentValue)it.next();
                    Iterator sibListIt = ((Chain)equivValToSiblingList.get(container2)).iterator();
                    while (sibListIt.hasNext()) {
                        killSet.add(sibListIt.next(), killSet);
                    }
                }
            }
            killSet.complement(killSet);
            this.unitToPreserveSet.put(s, killSet);
        }
        this.unitToGenerateSet = new HashMap(g.size() * 2 + 1, 0.7f);
        unitIt = g.iterator();
        while (unitIt.hasNext()) {
            AssignStmt as;
            Unit s = (Unit)unitIt.next();
            ArrayPackedSet genSet = new ArrayPackedSet(exprUniv);
            if (s instanceof AssignStmt && (as = (AssignStmt)s).getRightOp() instanceof Expr) {
                Value gen = as.getRightOp();
                boolean cantAdd = false;
                if (gen instanceof NewExpr || gen instanceof NewArrayExpr || gen instanceof NewMultiArrayExpr) {
                    cantAdd = true;
                }
                if (gen instanceof InvokeExpr) {
                    cantAdd = true;
                }
                if (!cantAdd) {
                    genSet.add(gen, genSet);
                }
            }
            genSet.intersection((FlowSet)this.unitToPreserveSet.get(s), genSet);
            this.unitToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    protected Object newInitialFlow() {
        BoundedFlowSet out = (BoundedFlowSet)this.emptySet.clone();
        out.complement(out);
        return out;
    }

    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.intersection((FlowSet)this.unitToPreserveSet.get(unit), out);
        out.union((FlowSet)this.unitToGenerateSet.get(unit), out);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

