/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.TransitiveTargets;
import soot.jimple.toolkits.pointer.MethodRWSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.SiteRWSet;
import soot.jimple.toolkits.pointer.StmtRWSet;

public class SideEffectAnalysis {
    PointsToAnalysis pa;
    CallGraph cg;
    Map methodToNTReadSet = new HashMap();
    Map methodToNTWriteSet = new HashMap();
    int rwsetcount = 0;
    TransitiveTargets tt;

    public void findNTRWSets(SootMethod method) {
        if (this.methodToNTReadSet.containsKey(method) && this.methodToNTWriteSet.containsKey(method)) {
            return;
        }
        MethodRWSet read = new MethodRWSet();
        MethodRWSet write = new MethodRWSet();
        Iterator sIt = method.retrieveActiveBody().getUnits().iterator();
        while (sIt.hasNext()) {
            Stmt s = (Stmt)sIt.next();
            read.union(this.ntReadSet(method, s));
            write.union(this.ntWriteSet(method, s));
        }
        this.methodToNTReadSet.put(method, read);
        this.methodToNTWriteSet.put(method, write);
        SootClass c = method.getDeclaringClass();
        if (!c.isApplicationClass()) {
            method.releaseActiveBody();
        }
    }

    public RWSet nonTransitiveReadSet(SootMethod method) {
        this.findNTRWSets(method);
        return (RWSet)this.methodToNTReadSet.get(method);
    }

    public RWSet nonTransitiveWriteSet(SootMethod method) {
        this.findNTRWSets(method);
        return (RWSet)this.methodToNTWriteSet.get(method);
    }

    public SideEffectAnalysis(PointsToAnalysis pa, CallGraph cg) {
        this.pa = pa;
        this.cg = cg;
        this.tt = new TransitiveTargets(cg);
    }

    private RWSet ntReadSet(SootMethod method, Stmt stmt) {
        if (stmt instanceof AssignStmt) {
            AssignStmt a = (AssignStmt)stmt;
            Value r = a.getRightOp();
            return this.addValue(r, method, stmt);
        }
        return null;
    }

    public RWSet readSet(SootMethod method, Stmt stmt) {
        RWSet ret = null;
        Iterator targets = this.tt.iterator(stmt);
        while (targets.hasNext()) {
            SootMethod target = (SootMethod)targets.next();
            if (target.isNative()) {
                if (ret == null) {
                    ret = new SiteRWSet();
                }
                ret.setCallsNative();
                continue;
            }
            if (!target.isConcrete()) continue;
            if (ret == null) {
                ret = new SiteRWSet();
            }
            ret.union(this.nonTransitiveReadSet(target));
        }
        if (ret == null) {
            return this.ntReadSet(method, stmt);
        }
        ret.union(this.ntReadSet(method, stmt));
        return ret;
    }

    private RWSet ntWriteSet(SootMethod method, Stmt stmt) {
        if (stmt instanceof AssignStmt) {
            AssignStmt a = (AssignStmt)stmt;
            Value l = a.getLeftOp();
            return this.addValue(l, method, stmt);
        }
        return null;
    }

    public RWSet writeSet(SootMethod method, Stmt stmt) {
        RWSet ret = null;
        Iterator targets = this.tt.iterator(stmt);
        while (targets.hasNext()) {
            SootMethod target = (SootMethod)targets.next();
            if (target.isNative()) {
                if (ret == null) {
                    ret = new SiteRWSet();
                }
                ret.setCallsNative();
                continue;
            }
            if (!target.isConcrete()) continue;
            if (ret == null) {
                ret = new SiteRWSet();
            }
            ret.union(this.nonTransitiveWriteSet(target));
        }
        if (ret == null) {
            return this.ntWriteSet(method, stmt);
        }
        ret.union(this.ntWriteSet(method, stmt));
        return ret;
    }

    protected RWSet addValue(Value v, SootMethod m, Stmt s) {
        StmtRWSet ret = null;
        if (v instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)v;
            PointsToSet base = this.pa.reachingObjects((Local)ifr.getBase());
            ret = new StmtRWSet();
            ((RWSet)ret).addFieldRef(base, ifr.getField());
        } else if (v instanceof StaticFieldRef) {
            StaticFieldRef sfr = (StaticFieldRef)v;
            ret = new StmtRWSet();
            ((RWSet)ret).addGlobal(sfr.getField());
        } else if (v instanceof ArrayRef) {
            ArrayRef ar = (ArrayRef)v;
            PointsToSet base = this.pa.reachingObjects((Local)ar.getBase());
            ret = new StmtRWSet();
            ((RWSet)ret).addFieldRef(base, PointsToAnalysis.ARRAY_ELEMENTS_NODE);
        }
        return ret;
    }

    public String toString() {
        return "SideEffectAnalysis: PA=" + this.pa + " CG=" + this.cg;
    }
}

