/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.EqExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.NeExpr;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.pointer.CastCheckTag;
import soot.jimple.toolkits.pointer.LocalTypeSet;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;
import soot.util.Chain;

public class CastCheckEliminator
extends ForwardBranchedFlowAnalysis {
    Map unitToKill = new HashMap();
    Map unitToGenFallThrough = new HashMap();
    Map unitToGenBranch = new HashMap();
    LocalTypeSet emptySet;

    public CastCheckEliminator(BriefUnitGraph cfg) {
        super(cfg);
        this.makeInitialSet();
        this.doAnalysis();
        this.tagCasts();
    }

    protected void tagCasts() {
        Iterator it = ((UnitGraph)this.graph).getBody().getUnits().iterator();
        while (it.hasNext()) {
            CastExpr cast;
            Type t;
            AssignStmt as;
            Value rhs;
            Stmt s = (Stmt)it.next();
            if (!(s instanceof AssignStmt) || !((rhs = (as = (AssignStmt)s).getRightOp()) instanceof CastExpr) || !((t = (cast = (CastExpr)rhs).getCastType()) instanceof RefType)) continue;
            Local l = (Local)cast.getOp();
            LocalTypeSet set = (LocalTypeSet)this.unitToBeforeFlow.get(s);
            s.addTag(new CastCheckTag(set.get(set.indexOf(l, (RefType)t))));
        }
    }

    protected void makeInitialSet() {
        Chain locals = ((UnitGraph)this.graph).getBody().getLocals();
        ArrayList<Local> refLocals = new ArrayList<Local>();
        Iterator it = locals.iterator();
        while (it.hasNext()) {
            Local l = (Local)it.next();
            if (!(l.getType() instanceof RefType)) continue;
            refLocals.add(l);
        }
        ArrayList<Type> types = new ArrayList<Type>();
        Iterator it2 = ((UnitGraph)this.graph).getBody().getUnits().iterator();
        while (it2.hasNext()) {
            Type t;
            AssignStmt as;
            Value rhs;
            Stmt s = (Stmt)it2.next();
            if (!(s instanceof AssignStmt) || !((rhs = (as = (AssignStmt)s).getRightOp()) instanceof CastExpr) || !((t = ((CastExpr)rhs).getCastType()) instanceof RefType) || types.contains(t)) continue;
            types.add(t);
        }
        this.emptySet = new LocalTypeSet(refLocals, types);
    }

    protected Object newInitialFlow() {
        LocalTypeSet ret = (LocalTypeSet)this.emptySet.clone();
        ret.setAllBits();
        return ret;
    }

    protected void flowThrough(Object inValue, Unit unit, List outFallValues, List outBranchValues) {
        LocalTypeSet out;
        LocalTypeSet in = (LocalTypeSet)inValue;
        LocalTypeSet outBranch = out = (LocalTypeSet)in.clone();
        Stmt stmt = (Stmt)unit;
        Iterator it = stmt.getDefBoxes().iterator();
        while (it.hasNext()) {
            ValueBox b = (ValueBox)it.next();
            Value v = b.getValue();
            if (!(v instanceof Local) || !(v.getType() instanceof RefType)) continue;
            out.killLocal((Local)v);
        }
        if (stmt instanceof AssignStmt) {
            AssignStmt astmt = (AssignStmt)stmt;
            Value rhs = astmt.getRightOp();
            Value lhs = astmt.getLeftOp();
            if (lhs instanceof Local && rhs.getType() instanceof RefType) {
                Local l = (Local)lhs;
                if (rhs instanceof NewExpr) {
                    out.localMustBeSubtypeOf(l, (RefType)rhs.getType());
                } else if (rhs instanceof CastExpr) {
                    CastExpr cast = (CastExpr)rhs;
                    Type castType = cast.getCastType();
                    if (castType instanceof RefType) {
                        out.localCopy(l, (Local)cast.getOp());
                        out.localMustBeSubtypeOf(l, (RefType)castType);
                        out.localMustBeSubtypeOf((Local)cast.getOp(), (RefType)castType);
                    }
                } else if (rhs instanceof Local) {
                    out.localCopy(l, (Local)rhs);
                }
            }
        } else if (stmt instanceof IfStmt) {
            ConditionExpr c;
            InstanceOfExpr iofexpr;
            AssignStmt pred;
            Stmt predecessor;
            IfStmt ifstmt = (IfStmt)stmt;
            if (this.graph.getPredsOf(stmt).size() == 1 && (predecessor = (Stmt)this.graph.getPredsOf(stmt).get(0)) instanceof AssignStmt && (pred = (AssignStmt)predecessor).getRightOp() instanceof InstanceOfExpr && (iofexpr = (InstanceOfExpr)pred.getRightOp()).getCheckType() instanceof RefType && (c = (ConditionExpr)ifstmt.getCondition()).getOp1().equals(pred.getLeftOp()) && c.getOp2() instanceof IntConstant && ((IntConstant)c.getOp2()).value == 0) {
                if (c instanceof NeExpr) {
                    outBranch = (LocalTypeSet)out.clone();
                    outBranch.localMustBeSubtypeOf((Local)iofexpr.getOp(), (RefType)iofexpr.getCheckType());
                } else if (c instanceof EqExpr) {
                    outBranch = (LocalTypeSet)out.clone();
                    out.localMustBeSubtypeOf((Local)iofexpr.getOp(), (RefType)iofexpr.getCheckType());
                }
            }
        }
        it = outFallValues.iterator();
        while (it.hasNext()) {
            this.copy(out, it.next());
        }
        it = outBranchValues.iterator();
        while (it.hasNext()) {
            this.copy(outBranch, it.next());
        }
    }

    protected void copy(Object source, Object dest) {
        LocalTypeSet s = (LocalTypeSet)source;
        LocalTypeSet d = (LocalTypeSet)dest;
        d.and(s);
        d.or(s);
    }

    protected void merge(Object in1, Object in2, Object out) {
        LocalTypeSet o = (LocalTypeSet)out;
        o.setAllBits();
        o.and((LocalTypeSet)in1);
        o.and((LocalTypeSet)in2);
    }

    protected Object entryInitialFlow() {
        LocalTypeSet ret = (LocalTypeSet)this.emptySet.clone();
        return ret;
    }
}

