/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.options.Options;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BriefBlockGraph;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.util.Chain;

public class LoopConditionUnroller
extends BodyTransformer {
    private Set visitingSuccs;
    private Set visitedBlocks;
    private int maxSize;
    private Body body;
    private Map unitsToTraps;

    protected void internalTransform(Body body, String phaseName, Map options) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     Unrolling Loop Conditions...");
        }
        this.visitingSuccs = new HashSet();
        this.visitedBlocks = new HashSet();
        this.body = body;
        this.maxSize = PhaseOptions.getInt(options, "maxSize");
        BriefBlockGraph bg = new BriefBlockGraph(body);
        Iterator headIter = bg.getHeads().iterator();
        while (headIter.hasNext()) {
            this.unrollConditions((Block)headIter.next());
        }
        CompleteUnitGraph cug = new CompleteUnitGraph(body);
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     Unrolling Loop Conditions done.");
        }
    }

    private Unit insertGotoAfter(Unit node, Unit target) {
        GotoStmt newGoto = Jimple.v().newGotoStmt(target);
        this.body.getUnits().insertAfter(newGoto, (Object)node);
        return newGoto;
    }

    private Unit insertCloneAfter(Chain unitChain, Unit node, Unit toClone) {
        Unit clone = (Unit)toClone.clone();
        this.body.getUnits().insertAfter(clone, (Object)node);
        return clone;
    }

    private Unit insertGotoBefore(Chain unitChain, Unit node, Unit target) {
        GotoStmt newGoto = Jimple.v().newGotoStmt(target);
        this.body.getUnits().insertBefore(newGoto, (Object)node);
        newGoto.redirectJumpsToThisTo(node);
        return newGoto;
    }

    private void redirectBranch(Unit node, Unit oldTarget, Unit newTarget) {
        Iterator targetIt = node.getUnitBoxes().iterator();
        while (targetIt.hasNext()) {
            UnitBox targetBox = (UnitBox)targetIt.next();
            Unit target = targetBox.getUnit();
            if (target != oldTarget) continue;
            targetBox.setUnit(newTarget);
        }
    }

    private int getSize(Block block) {
        int size = 0;
        PatchingChain unitChain = this.body.getUnits();
        Unit unit = block.getHead();
        while (unit != block.getTail()) {
            ++size;
            unit = (Unit)unitChain.getSuccOf(unit);
        }
        return ++size;
    }

    private Map getTraps() {
        if (this.unitsToTraps != null) {
            return this.unitsToTraps;
        }
        this.unitsToTraps = new HashMap();
        Iterator trapsIt = this.body.getTraps().iterator();
        while (trapsIt.hasNext()) {
            Trap trap = (Trap)trapsIt.next();
            Unit beginUnit = trap.getBeginUnit();
            List<Trap> unitTraps = (ArrayList<Trap>)this.unitsToTraps.get(beginUnit);
            if (unitTraps == null) {
                unitTraps = new ArrayList<Trap>();
                this.unitsToTraps.put(beginUnit, unitTraps);
            }
            unitTraps.add(trap);
            Unit endUnit = trap.getEndUnit();
            if (endUnit == beginUnit) continue;
            unitTraps = (List)this.unitsToTraps.get(endUnit);
            if (unitTraps == null) {
                unitTraps = new ArrayList();
                this.unitsToTraps.put(endUnit, unitTraps);
            }
            unitTraps.add(trap);
        }
        return this.unitsToTraps;
    }

    private Unit copyBlock(Block block) {
        Unit newGoto;
        Map traps = this.getTraps();
        HashSet<Trap> openedTraps = new HashSet<Trap>();
        HashMap<Trap, Trap> copiedTraps = new HashMap<Trap, Trap>();
        PatchingChain unitChain = this.body.getUnits();
        Unit tail = block.getTail();
        Unit immediateSucc = (Unit)unitChain.getSuccOf(tail);
        Unit last = newGoto = this.insertGotoAfter(tail, immediateSucc);
        boolean first = true;
        Unit copiedHead = null;
        Unit currentUnit = block.getHead();
        while (currentUnit != newGoto) {
            List currentTraps;
            last = this.insertCloneAfter(unitChain, last, currentUnit);
            if (first) {
                first = false;
                copiedHead = last;
            }
            if ((currentTraps = (List)traps.get(currentUnit)) != null) {
                Iterator trapIt = currentTraps.iterator();
                while (trapIt.hasNext()) {
                    Trap copiedTrap;
                    Trap trap = (Trap)trapIt.next();
                    if (trap.getBeginUnit() == currentUnit) {
                        copiedTrap = (Trap)trap.clone();
                        copiedTrap.setBeginUnit(last);
                        copiedTraps.put(trap, copiedTrap);
                        openedTraps.add(copiedTrap);
                        this.body.getTraps().insertAfter(copiedTrap, (Object)trap);
                    }
                    if (trap.getEndUnit() != currentUnit) continue;
                    copiedTrap = (Trap)copiedTraps.get(trap);
                    if (copiedTrap == null) {
                        copiedTrap = (Trap)trap.clone();
                        copiedTrap.setBeginUnit(copiedHead);
                        this.body.getTraps().insertAfter(copiedTrap, (Object)trap);
                    } else {
                        openedTraps.remove(copiedTrap);
                    }
                    copiedTrap.setEndUnit(last);
                }
            }
            currentUnit = (Unit)unitChain.getSuccOf(currentUnit);
        }
        Iterator openedIterator = openedTraps.iterator();
        while (openedIterator.hasNext()) {
            ((Trap)openedIterator.next()).setEndUnit(last);
        }
        return copiedHead;
    }

    private void unrollConditions(Block block) {
        if (this.visitedBlocks.contains(block)) {
            return;
        }
        this.visitedBlocks.add(block);
        this.visitingSuccs.add(block);
        Iterator succsIt = block.getSuccs().iterator();
        while (succsIt.hasNext()) {
            Block succ = (Block)succsIt.next();
            if (this.visitedBlocks.contains(succ)) {
                if (succ == block || !this.visitingSuccs.contains(succ) || succ.getPreds().size() < 2 || succ.getSuccs().size() != 2) continue;
                Block condition = succ;
                Block loopTailBlock = block;
                if (this.getSize(condition) > this.maxSize) continue;
                Unit copiedHead = this.copyBlock(condition);
                Unit loopTail = loopTailBlock.getTail();
                if (loopTail instanceof GotoStmt) {
                    ((GotoStmt)loopTail).setTarget(copiedHead);
                    continue;
                }
                if (loopTail instanceof IfStmt) {
                    if (((IfStmt)loopTail).getTarget() == condition.getHead()) {
                        ((IfStmt)loopTail).setTarget(copiedHead);
                        continue;
                    }
                    this.insertGotoAfter(loopTail, copiedHead);
                    continue;
                }
                this.insertGotoAfter(loopTail, copiedHead);
                continue;
            }
            this.unrollConditions(succ);
        }
        this.visitingSuccs.remove(block);
    }
}

