/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.MethodOrMethodContext;
import soot.jimple.toolkits.callgraph.Targets;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class ReachableMethods {
    private CallGraph cg;
    private List entryPoints = new ArrayList();
    private Iterator edgeSource;
    private ChunkedQueue reachables = new ChunkedQueue();
    private Set set = new HashSet();
    private QueueReader unprocessedMethods;
    private QueueReader allReachables = this.reachables.reader();
    private Filter filter;

    public ReachableMethods(CallGraph graph, Iterator entryPoints) {
        this(graph, entryPoints, null);
    }

    public ReachableMethods(CallGraph graph, Iterator entryPoints, Filter filter) {
        this.filter = filter;
        this.cg = graph;
        this.addMethods(entryPoints);
        this.unprocessedMethods = this.reachables.reader();
        this.edgeSource = graph.listener();
        if (filter != null) {
            this.edgeSource = filter.wrap(this.edgeSource);
        }
    }

    public ReachableMethods(CallGraph graph, Collection entryPoints) {
        this(graph, entryPoints.iterator());
    }

    private void addMethods(Iterator methods) {
        while (methods.hasNext()) {
            this.addMethod((MethodOrMethodContext)methods.next());
        }
    }

    private void addMethod(MethodOrMethodContext m) {
        if (this.set.add(m)) {
            this.reachables.add(m);
        }
    }

    public void update() {
        MethodOrMethodContext m;
        Edge e;
        while ((e = (Edge)this.edgeSource.next()) != null) {
            if (!this.set.contains(e.getSrc())) continue;
            this.addMethod(e.getTgt());
        }
        while ((m = (MethodOrMethodContext)this.unprocessedMethods.next()) != null) {
            Iterator targets = this.cg.edgesOutOf(m);
            if (this.filter != null) {
                targets = this.filter.wrap(targets);
            }
            this.addMethods(new Targets(targets));
        }
    }

    public QueueReader listener() {
        return (QueueReader)this.allReachables.clone();
    }

    public QueueReader newListener() {
        return this.reachables.reader();
    }

    public boolean contains(MethodOrMethodContext m) {
        return this.set.contains(m);
    }

    public int size() {
        return this.set.size();
    }
}

