/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.Unit;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.MethodOrMethodContext;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class CallGraph {
    private Set edges = new HashSet();
    private ChunkedQueue stream = new ChunkedQueue();
    private QueueReader reader = this.stream.reader();
    private Map srcMethodToEdge = new HashMap();
    private Map srcUnitToEdge = new HashMap();
    private Map tgtToEdge = new HashMap();
    private Edge dummy = new Edge(null, null, null, 0);

    public boolean addEdge(Edge e) {
        if (!this.edges.add(e)) {
            return false;
        }
        this.stream.add(e);
        Edge position = null;
        if (e.srcUnit() != null) {
            position = (Edge)this.srcUnitToEdge.get(e.srcUnit());
            if (position == null) {
                this.srcUnitToEdge.put(e.srcUnit(), e);
                position = (Edge)this.srcMethodToEdge.get(e.getSrc());
                if (position == null) {
                    this.srcMethodToEdge.put(e.getSrc(), e);
                    position = this.dummy;
                }
            }
        } else {
            position = (Edge)this.srcMethodToEdge.get(e.getSrc());
            if (position == null) {
                this.srcMethodToEdge.put(e.getSrc(), e);
                position = this.dummy;
            }
        }
        e.insertAfterBySrc(position);
        position = (Edge)this.tgtToEdge.get(e.getTgt());
        if (position == null) {
            this.tgtToEdge.put(e.getTgt(), e);
            position = this.dummy;
        }
        e.insertAfterByTgt(position);
        return true;
    }

    public boolean removeEdge(Edge e) {
        if (!this.edges.remove(e)) {
            return false;
        }
        e.remove();
        if (this.srcMethodToEdge.get(e.getSrc()) == e) {
            if (e.nextBySrc().getSrc() == e.getSrc()) {
                this.srcMethodToEdge.put(e.getSrc(), e.nextBySrc());
            } else {
                this.srcMethodToEdge.put(e.getSrc(), null);
            }
        }
        if (this.srcUnitToEdge.get(e.srcUnit()) == e) {
            if (e.nextBySrc().srcUnit() == e.srcUnit()) {
                this.srcUnitToEdge.put(e.srcUnit(), e.nextBySrc());
            } else {
                this.srcUnitToEdge.put(e.srcUnit(), null);
            }
        }
        if (this.tgtToEdge.get(e.getTgt()) == e) {
            if (e.nextByTgt().getTgt() == e.getTgt()) {
                this.tgtToEdge.put(e.getTgt(), e.nextByTgt());
            } else {
                this.tgtToEdge.put(e.getTgt(), null);
            }
        }
        return true;
    }

    public Iterator sourceMethods() {
        return this.srcMethodToEdge.keySet().iterator();
    }

    public Iterator edgesOutOf(Unit u) {
        return new TargetsOfUnitIterator(u);
    }

    public Iterator edgesOutOf(MethodOrMethodContext m) {
        return new TargetsOfMethodIterator(m);
    }

    public Iterator edgesInto(MethodOrMethodContext m) {
        return new CallersOfMethodIterator(m);
    }

    public QueueReader listener() {
        return (QueueReader)this.reader.clone();
    }

    public QueueReader newListener() {
        return this.stream.reader();
    }

    public String toString() {
        Edge e;
        QueueReader reader = this.listener();
        StringBuffer out = new StringBuffer();
        while ((e = (Edge)reader.next()) != null) {
            out.append(e.toString() + "\n");
        }
        return out.toString();
    }

    class CallersOfMethodIterator
    implements Iterator {
        private Edge position = null;
        private MethodOrMethodContext m;

        CallersOfMethodIterator(MethodOrMethodContext m) {
            this.m = m;
            if (m == null) {
                throw new RuntimeException();
            }
            this.position = (Edge)CallGraph.this.tgtToEdge.get(m);
            if (this.position == null) {
                this.position = CallGraph.this.dummy;
            }
        }

        public boolean hasNext() {
            if (this.position.getTgt() != this.m) {
                return false;
            }
            return this.position.kind() != 0;
        }

        public Object next() {
            Edge ret = this.position;
            this.position = this.position.nextByTgt();
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class TargetsOfMethodIterator
    implements Iterator {
        private Edge position = null;
        private MethodOrMethodContext m;

        TargetsOfMethodIterator(MethodOrMethodContext m) {
            this.m = m;
            if (m == null) {
                throw new RuntimeException();
            }
            this.position = (Edge)CallGraph.this.srcMethodToEdge.get(m);
            if (this.position == null) {
                this.position = CallGraph.this.dummy;
            }
        }

        public boolean hasNext() {
            if (this.position.getSrc() != this.m) {
                return false;
            }
            return this.position.kind() != 0;
        }

        public Object next() {
            Edge ret = this.position;
            this.position = this.position.nextBySrc();
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class TargetsOfUnitIterator
    implements Iterator {
        private Edge position = null;
        private Unit u;

        TargetsOfUnitIterator(Unit u) {
            this.u = u;
            if (u == null) {
                throw new RuntimeException();
            }
            this.position = (Edge)CallGraph.this.srcUnitToEdge.get(u);
            if (this.position == null) {
                this.position = CallGraph.this.dummy;
            }
        }

        public boolean hasNext() {
            if (this.position.srcUnit() != this.u) {
                return false;
            }
            return this.position.kind() != 0;
        }

        public Object next() {
            Edge ret = this.position;
            this.position = this.position.nextBySrc();
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

