/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.parity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import soot.Local;
import soot.Value;
import soot.jimple.AddExpr;
import soot.jimple.BinopExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.MulExpr;
import soot.jimple.Stmt;
import soot.jimple.SubExpr;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.Chain;

public class ParityAnalysis
extends ForwardFlowAnalysis {
    private UnitGraph g;
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private static final String EVEN = "even";
    private static final String ODD = "odd";

    public ParityAnalysis(UnitGraph g) {
        super(g);
        this.g = g;
        this.doAnalysis();
    }

    protected void merge(Object in1, Object in2, Object out) {
        HashMap inMap1 = (HashMap)in1;
        HashMap inMap2 = (HashMap)in2;
        HashMap outMap = (HashMap)out;
        Set keys = inMap1.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object var1 = it.next();
            String inVal1 = (String)inMap1.get(var1);
            String inVal2 = (String)inMap2.get(var1);
            if (inVal2 == null) {
                outMap.put(var1, inVal1);
                continue;
            }
            if (inVal1.equals(BOTTOM)) {
                outMap.put(var1, inVal2);
                continue;
            }
            if (inVal2.equals(BOTTOM)) {
                outMap.put(var1, inVal1);
                continue;
            }
            if (inVal1.equals(EVEN) && inVal2.equals(EVEN)) {
                outMap.put(var1, EVEN);
                continue;
            }
            if (inVal1.equals(ODD) && inVal2.equals(ODD)) {
                outMap.put(var1, ODD);
                continue;
            }
            outMap.put(var1, TOP);
        }
    }

    protected void copy(Object source, Object dest) {
        HashMap sourceIn = (HashMap)source;
        HashMap destOut = (HashMap)dest;
        destOut.putAll(sourceIn);
        dest = destOut;
    }

    private String getParity(HashMap in, Value val) {
        if (val instanceof AddExpr | val instanceof SubExpr) {
            String resVal1 = this.getParity(in, ((BinopExpr)val).getOp1());
            String resVal2 = this.getParity(in, ((BinopExpr)val).getOp2());
            if (resVal1.equals(TOP) | resVal2.equals(TOP)) {
                return TOP;
            }
            if (resVal1.equals(BOTTOM) | resVal2.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (resVal1.equals(resVal2)) {
                return EVEN;
            }
            return ODD;
        }
        if (val instanceof MulExpr) {
            String resVal1 = this.getParity(in, ((BinopExpr)val).getOp1());
            String resVal2 = this.getParity(in, ((BinopExpr)val).getOp2());
            if (resVal1.equals(TOP) | resVal2.equals(TOP)) {
                return TOP;
            }
            if (resVal1.equals(BOTTOM) | resVal2.equals(BOTTOM)) {
                return BOTTOM;
            }
            if (resVal1.equals(ODD) && resVal2.equals(ODD)) {
                return ODD;
            }
            return EVEN;
        }
        if (val instanceof IntConstant) {
            int value = ((IntConstant)val).value;
            if (value % 2 == 0) {
                return EVEN;
            }
            return ODD;
        }
        if (val instanceof LongConstant) {
            long value = ((LongConstant)val).value;
            if (value % 2L == 0L) {
                return EVEN;
            }
            return ODD;
        }
        if (in.containsKey(val)) {
            return (String)in.get(val);
        }
        return TOP;
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        Value left;
        HashMap in = (HashMap)inValue;
        HashMap out = (HashMap)outValue;
        Stmt s = (Stmt)unit;
        out.putAll(in);
        if (s instanceof DefinitionStmt && (left = ((DefinitionStmt)s).getLeftOp()) instanceof Local) {
            Value right = ((DefinitionStmt)s).getRightOp();
            out.put(left, this.getParity(out, right));
        }
    }

    protected Object entryInitialFlow() {
        HashMap initMap = new HashMap();
        Chain locals = this.g.getBody().getLocals();
        Iterator it = locals.iterator();
        while (it.hasNext()) {
            initMap.put(it.next(), BOTTOM);
        }
        return initMap;
    }

    protected Object newInitialFlow() {
        HashMap initMap = new HashMap();
        Chain locals = this.g.getBody().getLocals();
        Iterator it = locals.iterator();
        while (it.hasNext()) {
            initMap.put(it.next(), BOTTOM);
        }
        return initMap;
    }
}

