/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.EquivalentValue;
import soot.Unit;
import soot.Value;
import soot.jimple.toolkits.annotation.nullcheck.BranchedRefVarsAnalysis;
import soot.jimple.toolkits.annotation.nullcheck.RefIntPair;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.FlowSet;

public class LocalRefVarsAnalysisWrapper {
    private static final boolean computeChecks = true;
    private static final boolean discardKTop = true;
    Map unitToVarsBefore;
    Map unitToVarsAfterFall;
    Map unitToListsOfVarsAfterBranches;
    Map unitToVarsNeedCheck;
    Map unitToVarsDontNeedCheck;
    BranchedRefVarsAnalysis analysis;

    private final List buildList(FlowSet set) {
        ArrayList<RefIntPair> lst = new ArrayList<RefIntPair>();
        Iterator it = this.analysis.refTypeValues.iterator();
        while (it.hasNext()) {
            EquivalentValue r = (EquivalentValue)it.next();
            int refInfo = this.analysis.refInfo(r, set);
            this.analysis.getClass();
            if (refInfo == 99) continue;
            lst.add(this.analysis.getKRefIntPair(r, refInfo));
        }
        return lst;
    }

    public LocalRefVarsAnalysisWrapper(CompleteUnitGraph graph) {
        this.analysis = new BranchedRefVarsAnalysis(graph);
        this.unitToVarsBefore = new HashMap(graph.size() * 2 + 1, 0.7f);
        this.unitToVarsAfterFall = new HashMap(graph.size() * 2 + 1, 0.7f);
        this.unitToListsOfVarsAfterBranches = new HashMap(graph.size() * 2 + 1, 0.7f);
        this.unitToVarsNeedCheck = new HashMap(graph.size() * 2 + 1, 0.7f);
        this.unitToVarsDontNeedCheck = new HashMap(graph.size() * 2 + 1, 0.7f);
        Iterator unitIt = graph.iterator();
        while (unitIt.hasNext()) {
            Unit s = (Unit)unitIt.next();
            FlowSet set = (FlowSet)this.analysis.getFallFlowAfter(s);
            this.unitToVarsAfterFall.put(s, Collections.unmodifiableList(this.buildList(set)));
            List branchesFlowsets = this.analysis.getBranchFlowAfter(s);
            ArrayList lst = new ArrayList(branchesFlowsets.size());
            Iterator it = branchesFlowsets.iterator();
            while (it.hasNext()) {
                set = (FlowSet)it.next();
                lst.add(Collections.unmodifiableList(this.buildList(set)));
            }
            this.unitToListsOfVarsAfterBranches.put(s, lst);
            set = (FlowSet)this.analysis.getFlowBefore(s);
            this.unitToVarsBefore.put(s, Collections.unmodifiableList(this.buildList(set)));
            ArrayList<RefIntPair> dontNeedCheckVars = new ArrayList<RefIntPair>();
            ArrayList<Object> needCheckVars = new ArrayList<Object>();
            HashSet allChecksSet = new HashSet(5, 0.7f);
            allChecksSet.addAll((HashSet)this.analysis.unitToArrayRefChecksSet.get(s));
            allChecksSet.addAll((HashSet)this.analysis.unitToInstanceFieldRefChecksSet.get(s));
            allChecksSet.addAll((HashSet)this.analysis.unitToInstanceInvokeExprChecksSet.get(s));
            allChecksSet.addAll((HashSet)this.analysis.unitToLengthExprChecksSet.get(s));
            Iterator it2 = allChecksSet.iterator();
            while (it2.hasNext()) {
                Value v = (Value)it2.next();
                int vInfo = this.analysis.anyRefInfo(v, set);
                this.analysis.getClass();
                if (vInfo == 99) {
                    needCheckVars.add(v);
                    continue;
                }
                this.analysis.getClass();
                if (vInfo == 0) {
                    needCheckVars.add(this.analysis.getKRefIntPair(new EquivalentValue(v), vInfo));
                    continue;
                }
                dontNeedCheckVars.add(this.analysis.getKRefIntPair(new EquivalentValue(v), vInfo));
            }
            this.unitToVarsNeedCheck.put(s, Collections.unmodifiableList(needCheckVars));
            this.unitToVarsDontNeedCheck.put(s, Collections.unmodifiableList(dontNeedCheckVars));
        }
    }

    public List getVarsBefore(Unit s) {
        return (List)this.unitToVarsBefore.get(s);
    }

    public List getVarsAfterFall(Unit s) {
        return (List)this.unitToVarsAfterFall.get(s);
    }

    public List getListsOfVarsAfterBranch(Unit s) {
        return (List)this.unitToListsOfVarsAfterBranches.get(s);
    }

    public List getVarsNeedCheck(Unit s) {
        return (List)this.unitToVarsNeedCheck.get(s);
    }

    public List getVarsDontNeedCheck(Unit s) {
        return (List)this.unitToVarsDontNeedCheck.get(s);
    }
}

