/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.Iterator;
import java.util.List;
import soot.toolkits.graph.HashMutableDirectedGraph;

class ExtendedHashMutableDirectedGraph
extends HashMutableDirectedGraph {
    public void addEdge(Object from, Object to) {
        if (!super.containsNode(from)) {
            super.addNode(from);
        }
        if (!super.containsNode(to)) {
            super.addNode(to);
        }
        super.addEdge(from, to);
    }

    public void addMutualEdge(Object from, Object to) {
        if (!super.containsNode(from)) {
            super.addNode(from);
        }
        if (!super.containsNode(to)) {
            super.addNode(to);
        }
        super.addEdge(from, to);
        super.addEdge(to, from);
    }

    public void skipNode(Object node) {
        int i;
        if (!super.containsNode(node)) {
            return;
        }
        Object[] preds = this.getPredsOf(node).toArray();
        Object[] succs = this.getSuccsOf(node).toArray();
        for (i = 0; i < preds.length; ++i) {
            for (int j = 0; j < succs.length; ++j) {
                if (preds[i] == succs[j]) continue;
                super.addEdge(preds[i], succs[j]);
            }
        }
        for (i = 0; i < preds.length; ++i) {
            super.removeEdge(preds[i], node);
        }
        for (int j = 0; j < succs.length; ++j) {
            super.removeEdge(node, succs[j]);
        }
        super.removeNode(node);
    }

    public void mergeWith(ExtendedHashMutableDirectedGraph other) {
        List nodes = other.getNodes();
        Iterator nodesIt = nodes.iterator();
        while (nodesIt.hasNext()) {
            Object node = nodesIt.next();
            List succs = other.getSuccsOf(node);
            Iterator succsIt = succs.iterator();
            while (succsIt.hasNext()) {
                Object succ = succsIt.next();
                this.addEdge(node, succ);
            }
        }
    }

    public String toString() {
        String rtn = "Graph:\n";
        List nodes = super.getNodes();
        Iterator nodesIt = nodes.iterator();
        while (nodesIt.hasNext()) {
            Object node = nodesIt.next();
            List succs = super.getSuccsOf(node);
            Iterator succsIt = succs.iterator();
            while (succsIt.hasNext()) {
                Object succ = succsIt.next();
                rtn = rtn + node + "\t --- \t" + succ + "\n";
            }
        }
        return rtn;
    }
}

