/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.arraycheck.ArrayBoundsCheckerAnalysis;
import soot.jimple.toolkits.annotation.arraycheck.IntContainer;
import soot.jimple.toolkits.annotation.arraycheck.MethodLocal;
import soot.jimple.toolkits.annotation.arraycheck.RectangularArrayFinder;
import soot.jimple.toolkits.annotation.arraycheck.WeightedDirectedSparseGraph;
import soot.jimple.toolkits.annotation.tags.ArrayCheckTag;
import soot.options.ABCOptions;
import soot.options.Options;
import soot.tagkit.ColorTag;
import soot.tagkit.KeyTag;

public class ArrayBoundsChecker
extends BodyTransformer {
    protected boolean takeClassField = false;
    protected boolean takeFieldRef = false;
    protected boolean takeArrayRef = false;
    protected boolean takeCSE = false;
    protected boolean takeRectArray = false;
    protected boolean addColorTags = false;

    public ArrayBoundsChecker(Singletons.Global g) {
    }

    public static ArrayBoundsChecker v() {
        return G.v().ArrayBoundsChecker();
    }

    protected void internalTransform(Body body, String phaseName, Map opts) {
        ABCOptions options = new ABCOptions(opts);
        if (options.with_all()) {
            this.takeClassField = true;
            this.takeFieldRef = true;
            this.takeArrayRef = true;
            this.takeCSE = true;
            this.takeRectArray = true;
        } else {
            this.takeClassField = options.with_classfield();
            this.takeFieldRef = options.with_fieldref();
            this.takeArrayRef = options.with_arrayref();
            this.takeCSE = options.with_cse();
            this.takeRectArray = options.with_rectarray();
        }
        this.addColorTags = options.add_color_tags();
        SootMethod m = body.getMethod();
        Date start = new Date();
        if (Options.v().verbose()) {
            G.v().out.println("[abc] Analyzing array bounds information for " + m.getName());
            G.v().out.println("[abc] Started on " + start);
        }
        ArrayBoundsCheckerAnalysis analysis = null;
        if (this.hasArrayLocals(body)) {
            analysis = new ArrayBoundsCheckerAnalysis(body, this.takeClassField, this.takeFieldRef, this.takeArrayRef, this.takeCSE, this.takeRectArray);
        }
        SootClass counterClass = null;
        SootMethod increase = null;
        if (options.profiling()) {
            counterClass = Scene.v().loadClassAndSupport("MultiCounter");
            increase = counterClass.getMethod("void increase(int)");
        }
        PatchingChain units = body.getUnits();
        IntContainer zero = new IntContainer(0);
        Iterator unitIt = units.snapshotIterator();
        while (unitIt.hasNext()) {
            Stmt stmt = (Stmt)unitIt.next();
            if (!stmt.containsArrayRef()) continue;
            ArrayRef aref = stmt.getArrayRef();
            WeightedDirectedSparseGraph vgraph = (WeightedDirectedSparseGraph)analysis.getFlowBefore(stmt);
            int res = this.interpretGraph(vgraph, aref, stmt, zero);
            boolean lowercheck = true;
            boolean uppercheck = true;
            if (res == 0) {
                lowercheck = true;
                uppercheck = true;
            } else if (res == 1) {
                lowercheck = true;
                uppercheck = false;
            } else if (res == 2) {
                lowercheck = false;
                uppercheck = true;
            } else if (res == 3) {
                lowercheck = false;
                uppercheck = false;
            }
            if (this.addColorTags) {
                if (res == 0) {
                    aref.getIndexBox().addTag(new ColorTag(255, 0, 0, false));
                } else if (res == 1) {
                    aref.getIndexBox().addTag(new ColorTag(255, 248, 35, false));
                } else if (res == 2) {
                    aref.getIndexBox().addTag(new ColorTag(255, 163, 0, false));
                } else if (res == 3) {
                    aref.getIndexBox().addTag(new ColorTag(45, 255, 84, false));
                }
                SootClass bodyClass = body.getMethod().getDeclaringClass();
                Iterator keysIt = bodyClass.getTags().iterator();
                boolean keysAdded = false;
                while (keysIt.hasNext()) {
                    if (!(keysIt.next() instanceof KeyTag)) continue;
                    keysAdded = true;
                }
                if (!keysAdded) {
                    bodyClass.addTag(new KeyTag(255, 0, 0, "ArrayBounds: Unsafe Lower and Unsafe Upper"));
                    bodyClass.addTag(new KeyTag(255, 248, 35, "ArrayBounds: Unsafe Lower and Safe Upper"));
                    bodyClass.addTag(new KeyTag(255, 163, 0, "ArrayBounds: Safe Lower and Unsafe Upper"));
                    bodyClass.addTag(new KeyTag(45, 255, 84, "ArrayBounds: Safe Lower and Safe Upper"));
                }
            }
            if (options.profiling()) {
                int lowercounter = 0;
                if (!lowercheck) {
                    lowercounter = 1;
                }
                units.insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(increase, IntConstant.v(lowercounter))), (Object)stmt);
                int uppercounter = 2;
                if (!uppercheck) {
                    uppercounter = 3;
                }
                units.insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(increase, IntConstant.v(uppercounter))), (Object)stmt);
                continue;
            }
            ArrayCheckTag checkTag = new ArrayCheckTag(lowercheck, uppercheck);
            stmt.addTag(checkTag);
        }
        if (this.addColorTags && this.takeRectArray) {
            RectangularArrayFinder raf = RectangularArrayFinder.v();
            Iterator vbIt = body.getUseAndDefBoxes().iterator();
            while (vbIt.hasNext()) {
                Type t;
                ValueBox vb = (ValueBox)vbIt.next();
                Value v = vb.getValue();
                if (!(v instanceof Local) || !((t = v.getType()) instanceof ArrayType)) continue;
                ArrayType at = (ArrayType)t;
                if (at.numDimensions <= 1) continue;
                vb.addTag(new ColorTag(raf.isRectangular(new MethodLocal(m, (Local)v)) ? 1 : 0));
            }
        }
        Date finish = new Date();
        if (Options.v().verbose()) {
            long runtime = finish.getTime() - start.getTime();
            G.v().out.println("[abc] ended on " + finish + ". It took " + runtime / 60000L + " min. " + runtime % 60000L / 1000L + " sec.");
        }
    }

    private boolean hasArrayLocals(Body body) {
        Iterator localIt = body.getLocals().iterator();
        while (localIt.hasNext()) {
            Local local = (Local)localIt.next();
            if (!(local.getType() instanceof ArrayType)) continue;
            return true;
        }
        return false;
    }

    protected int interpretGraph(WeightedDirectedSparseGraph vgraph, ArrayRef aref, Stmt stmt, IntContainer zero) {
        boolean lowercheck = true;
        boolean uppercheck = true;
        if (Options.v().debug() && !vgraph.makeShortestPathGraph()) {
            G.v().out.println(stmt + " :");
            G.v().out.println(vgraph);
        }
        Value base = aref.getBase();
        Value index = aref.getIndex();
        if (index instanceof IntConstant) {
            int alength;
            int indexv = ((IntConstant)index).value;
            if (vgraph.hasEdge(base, zero) && -(alength = vgraph.edgeWeight(base, zero)) > indexv) {
                uppercheck = false;
            }
            if (indexv >= 0) {
                lowercheck = false;
            }
        } else {
            int lowerdistance;
            int upperdistance;
            if (vgraph.hasEdge(base, index) && (upperdistance = vgraph.edgeWeight(base, index)) < 0) {
                uppercheck = false;
            }
            if (vgraph.hasEdge(index, zero) && (lowerdistance = vgraph.edgeWeight(index, zero)) <= 0) {
                lowercheck = false;
            }
        }
        if (lowercheck && uppercheck) {
            return 0;
        }
        if (lowercheck && !uppercheck) {
            return 1;
        }
        if (!lowercheck && uppercheck) {
            return 2;
        }
        return 3;
    }
}

