/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.TopoSorter;

public class SCCCollapser {
    protected int numCollapsed = 0;
    protected PAG pag;
    protected HashSet visited = new HashSet();
    protected boolean ignoreTypes;
    protected TypeManager typeManager;

    public void collapse() {
        VarNode v;
        boolean verbose = this.pag.getOpts().verbose();
        if (verbose) {
            G.v().out.println("Total VarNodes: " + this.pag.getVarNodeNumberer().size() + ". Collapsing SCCs...");
        }
        new TopoSorter(this.pag, this.ignoreTypes).sort();
        TreeSet<VarNode> s = new TreeSet<VarNode>();
        Iterator vIt = this.pag.getVarNodeNumberer().iterator();
        while (vIt.hasNext()) {
            v = (VarNode)vIt.next();
            s.add(v);
        }
        vIt = s.iterator();
        while (vIt.hasNext()) {
            v = (VarNode)vIt.next();
            this.dfsVisit(v, v);
        }
        if (verbose) {
            G.v().out.println("" + this.numCollapsed + " nodes were collapsed.");
        }
        this.visited = null;
    }

    public SCCCollapser(PAG pag, boolean ignoreTypes) {
        this.pag = pag;
        this.ignoreTypes = ignoreTypes;
        this.typeManager = (TypeManager)pag.getTypeManager();
    }

    protected final void dfsVisit(VarNode v, VarNode rootOfSCC) {
        if (this.visited.contains(v)) {
            return;
        }
        this.visited.add(v);
        Node[] succs = this.pag.simpleInvLookup(v);
        for (int i = 0; i < succs.length; ++i) {
            if (!this.ignoreTypes && !this.typeManager.castNeverFails(succs[i].getType(), v.getType())) continue;
            this.dfsVisit((VarNode)succs[i], rootOfSCC);
        }
        if (v != rootOfSCC) {
            if (!this.ignoreTypes) {
                if (this.typeManager.castNeverFails(v.getType(), rootOfSCC.getType()) && this.typeManager.castNeverFails(rootOfSCC.getType(), v.getType())) {
                    rootOfSCC.mergeWith(v);
                    ++this.numCollapsed;
                }
            } else {
                if (this.typeManager.castNeverFails(v.getType(), rootOfSCC.getType())) {
                    rootOfSCC.mergeWith(v);
                } else if (this.typeManager.castNeverFails(rootOfSCC.getType(), v.getType())) {
                    v.mergeWith(rootOfSCC);
                } else {
                    rootOfSCC.getReplacement().setType(null);
                    PointsToSetInternal set = rootOfSCC.getP2Set();
                    if (set != null) {
                        set.setType(null);
                    }
                    rootOfSCC.mergeWith(v);
                }
                ++this.numCollapsed;
            }
        }
    }
}

