/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;

public final class PropMerge
extends Propagator {
    protected final Set varNodeWorkList = new TreeSet();
    protected PAG pag;

    public PropMerge(PAG pag) {
        this.pag = pag;
    }

    public final void propagate() {
        new TopoSorter(this.pag, false).sort();
        Iterator it = this.pag.allocSources().iterator();
        while (it.hasNext()) {
            this.handleAllocNode((AllocNode)it.next());
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            int i;
            ValNode src;
            if (verbose) {
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            int iter = 0;
            while (!this.varNodeWorkList.isEmpty()) {
                VarNode src2 = (VarNode)this.varNodeWorkList.iterator().next();
                this.varNodeWorkList.remove(src2);
                this.handleVarNode(src2);
                if (!verbose || ++iter < 1000) continue;
                iter = 0;
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            if (verbose) {
                G.v().out.println("Now handling field references");
            }
            Iterator srcIt = this.pag.storeSources().iterator();
            while (srcIt.hasNext()) {
                src = (VarNode)srcIt.next();
                Node[] storeTargets = this.pag.storeLookup((VarNode)src);
                for (i = 0; i < storeTargets.length; ++i) {
                    FieldRefNode fr = (FieldRefNode)storeTargets[i];
                    fr.makeP2Set().addAll(src.getP2Set(), null);
                }
            }
            srcIt = this.pag.loadSources().iterator();
            while (srcIt.hasNext()) {
                src = (FieldRefNode)srcIt.next();
                if (src != ((FieldRefNode)src).getReplacement()) {
                    throw new RuntimeException("shouldn't happen");
                }
                Node[] targets = this.pag.loadLookup((FieldRefNode)src);
                for (i = 0; i < targets.length; ++i) {
                    VarNode target = (VarNode)targets[i];
                    if (!target.makeP2Set().addAll(src.getP2Set(), null)) continue;
                    this.varNodeWorkList.add(target);
                }
            }
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected final boolean handleAllocNode(AllocNode src) {
        boolean ret = false;
        Node[] targets = this.pag.allocLookup(src);
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].makeP2Set().add(src)) continue;
            this.varNodeWorkList.add(targets[i]);
            ret = true;
        }
        return ret;
    }

    protected final boolean handleVarNode(VarNode src) {
        FieldRefNode fr;
        boolean ret = false;
        if (src.getReplacement() != src) {
            return ret;
        }
        PointsToSetInternal newP2Set = src.getP2Set();
        if (newP2Set.isEmpty()) {
            return false;
        }
        Node[] simpleTargets = this.pag.simpleLookup(src);
        for (int i = 0; i < simpleTargets.length; ++i) {
            if (!simpleTargets[i].makeP2Set().addAll(newP2Set, null)) continue;
            this.varNodeWorkList.add(simpleTargets[i]);
            ret = true;
        }
        Node[] storeTargets = this.pag.storeLookup(src);
        for (int i = 0; i < storeTargets.length; ++i) {
            fr = (FieldRefNode)storeTargets[i];
            if (!fr.makeP2Set().addAll(newP2Set, null)) continue;
            ret = true;
        }
        Iterator frIt = src.getAllFieldRefs().iterator();
        while (frIt.hasNext()) {
            fr = (FieldRefNode)frIt.next();
            final SparkField field = fr.getField();
            ret = newP2Set.forall(new P2SetVisitor(){

                public final void visit(Node n) {
                    AllocDotField nDotF = PropMerge.this.pag.makeAllocDotField((AllocNode)n, field);
                    Node nDotFNode = nDotF.getReplacement();
                    if (nDotFNode != fr) {
                        fr.mergeWith(nDotFNode);
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        return ret;
    }
}

