/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.sets;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.PointsToSet;
import soot.Type;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.StringConstantNode;
import soot.relations.Relation;

public class BDDPointsToSet
implements PointsToSet {
    private final Relation bdd;

    public BDDPointsToSet(Relation bdd) {
        this.bdd = bdd;
    }

    public boolean isEmpty() {
        return this.bdd.isEmpty();
    }

    public boolean hasNonEmptyIntersection(PointsToSet other) {
        BDDPointsToSet o = (BDDPointsToSet)other;
        Relation intersection = this.bdd.sameDomains();
        intersection.eqIntersect(this.bdd, o.bdd);
        return !intersection.isEmpty();
    }

    public Set possibleTypes() {
        HashSet<Type> ret = new HashSet<Type>();
        Iterator it = this.bdd.iterator();
        while (it.hasNext()) {
            AllocNode an = (AllocNode)it.next();
            ret.add(an.getType());
        }
        return ret;
    }

    public Set possibleStringConstants() {
        HashSet<String> ret = new HashSet<String>();
        Iterator it = this.bdd.iterator();
        while (it.hasNext()) {
            AllocNode an = (AllocNode)it.next();
            if (!(an instanceof StringConstantNode)) {
                return null;
            }
            StringConstantNode scn = (StringConstantNode)an;
            ret.add(scn.getString());
        }
        return ret;
    }

    public Set possibleClassConstants() {
        HashSet<String> ret = new HashSet<String>();
        Iterator it = this.bdd.iterator();
        while (it.hasNext()) {
            AllocNode an = (AllocNode)it.next();
            if (!(an instanceof ClassConstantNode)) {
                return null;
            }
            ClassConstantNode scn = (ClassConstantNode)an;
            ret.add(scn.getString());
        }
        return ret;
    }
}

