/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import soot.AnySubType;
import soot.G;
import soot.RefLikeType;
import soot.Type;
import soot.jimple.spark.pag.AbstractPAG;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.ValNode;

public abstract class VarNode
extends ValNode
implements Comparable {
    protected Object variable;
    protected Map fields;
    protected int finishingNumber = 0;
    protected boolean interProcTarget = false;
    protected boolean interProcSource = false;
    protected int numDerefs = 0;

    public Object context() {
        return null;
    }

    public Collection getAllFieldRefs() {
        if (this.fields == null) {
            return Collections.EMPTY_LIST;
        }
        return this.fields.values();
    }

    public FieldRefNode dot(SparkField field) {
        return this.fields == null ? null : (FieldRefNode)this.fields.get(field);
    }

    public int compareTo(Object o) {
        VarNode other = (VarNode)o;
        if (other.finishingNumber == this.finishingNumber && other != this) {
            G.v().out.println("This is: " + this + " with id " + this.getNumber() + " and number " + this.finishingNumber);
            G.v().out.println("Other is: " + other + " with id " + other.getNumber() + " and number " + other.finishingNumber);
            throw new RuntimeException("Comparison error");
        }
        return other.finishingNumber - this.finishingNumber;
    }

    public void setFinishingNumber(int i) {
        this.finishingNumber = i;
        if (i > this.pag.maxFinishNumber) {
            this.pag.maxFinishNumber = i;
        }
    }

    public Object getVariable() {
        return this.variable;
    }

    public void setInterProcTarget() {
        this.interProcTarget = true;
    }

    public boolean isInterProcTarget() {
        return this.interProcTarget;
    }

    public void setInterProcSource() {
        this.interProcSource = true;
    }

    public boolean isInterProcSource() {
        return this.interProcSource;
    }

    VarNode(AbstractPAG pag, Object variable, Type t) {
        super(pag, t);
        if (!(t instanceof RefLikeType) || t instanceof AnySubType) {
            throw new RuntimeException("Attempt to create VarNode of type " + t);
        }
        this.variable = variable;
        pag.getVarNodeNumberer().add(this);
        this.setFinishingNumber(++pag.maxFinishNumber);
    }

    void addField(FieldRefNode frn, SparkField field) {
        if (this.fields == null) {
            this.fields = new HashMap();
        }
        this.fields.put(field, frn);
    }
}

