/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.Numberer;

public class PAGDumper {
    protected PAG pag;
    protected String output_dir;
    protected int fieldNum = 0;
    protected HashMap fieldMap = new HashMap();
    protected ObjectNumberer root = new ObjectNumberer(null, 0);

    public PAGDumper(PAG pag, String output_dir) {
        this.pag = pag;
        this.output_dir = output_dir;
    }

    public void dumpPointsToSets() {
        try {
            final PrintWriter file = new PrintWriter(new FileOutputStream(new File(this.output_dir, "solution")));
            file.println("Solution:");
            Numberer.NumbererIterator vnIt = this.pag.getVarNodeNumberer().iterator();
            while (vnIt.hasNext()) {
                PointsToSetInternal p2set;
                final VarNode vn = (VarNode)vnIt.next();
                if (vn.getReplacement() != vn || (p2set = vn.getP2Set()) == null) continue;
                p2set.forall(new P2SetVisitor(){

                    public final void visit(Node n) {
                        try {
                            PAGDumper.this.dumpNode(vn, file);
                            file.print(" ");
                            PAGDumper.this.dumpNode(n, file);
                            file.println("");
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Couldn't dump solution." + e);
                        }
                    }
                });
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public void dump() {
        try {
            int i;
            Node[] succs;
            Node n;
            PrintWriter file = new PrintWriter(new FileOutputStream(new File(this.output_dir, "pag")));
            if (this.pag.getOpts().topo_sort()) {
                new TopoSorter(this.pag, false).sort();
            }
            file.println("Allocations:");
            Iterator nIt = this.pag.allocSources().iterator();
            while (nIt.hasNext()) {
                n = (AllocNode)nIt.next();
                if (n.getReplacement() != n) continue;
                succs = this.pag.allocLookup((AllocNode)n);
                for (i = 0; i < succs.length; ++i) {
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(succs[i], file);
                    file.println("");
                }
            }
            file.println("Assignments:");
            nIt = this.pag.simpleSources().iterator();
            while (nIt.hasNext()) {
                n = (VarNode)nIt.next();
                if (n.getReplacement() != n) continue;
                succs = this.pag.simpleLookup((VarNode)n);
                for (i = 0; i < succs.length; ++i) {
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(succs[i], file);
                    file.println("");
                }
            }
            file.println("Loads:");
            nIt = this.pag.loadSources().iterator();
            while (nIt.hasNext()) {
                n = (FieldRefNode)nIt.next();
                succs = this.pag.loadLookup((FieldRefNode)n);
                for (i = 0; i < succs.length; ++i) {
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(succs[i], file);
                    file.println("");
                }
            }
            file.println("Stores:");
            nIt = this.pag.storeSources().iterator();
            while (nIt.hasNext()) {
                n = (VarNode)nIt.next();
                if (n.getReplacement() != n) continue;
                succs = this.pag.storeLookup((VarNode)n);
                for (i = 0; i < succs.length; ++i) {
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(succs[i], file);
                    file.println("");
                }
            }
            if (this.pag.getOpts().dump_types()) {
                this.dumpTypes(file);
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump PAG." + e);
        }
    }

    protected void dumpTypes(PrintWriter file) throws IOException {
        Type t;
        Node n;
        Type t2;
        Node n2;
        HashSet<Type> declaredTypes = new HashSet<Type>();
        HashSet<Type> actualTypes = new HashSet<Type>();
        HashSet<SparkField> allFields = new HashSet<SparkField>();
        Iterator nIt = this.pag.getVarNodeNumberer().iterator();
        while (nIt.hasNext()) {
            n2 = (Node)nIt.next();
            t2 = n2.getType();
            if (t2 == null) continue;
            declaredTypes.add(t2);
        }
        nIt = this.pag.loadSources().iterator();
        while (nIt.hasNext()) {
            n2 = (Node)nIt.next();
            if (n2.getReplacement() != n2) continue;
            t2 = n2.getType();
            if (t2 != null) {
                declaredTypes.add(t2);
            }
            allFields.add(((FieldRefNode)n2).getField());
        }
        nIt = this.pag.storeInvSources().iterator();
        while (nIt.hasNext()) {
            n2 = (Node)nIt.next();
            if (n2.getReplacement() != n2) continue;
            t2 = n2.getType();
            if (t2 != null) {
                declaredTypes.add(t2);
            }
            allFields.add(((FieldRefNode)n2).getField());
        }
        nIt = this.pag.allocSources().iterator();
        while (nIt.hasNext()) {
            n2 = (Node)nIt.next();
            if (n2.getReplacement() != n2 || (t2 = n2.getType()) == null) continue;
            actualTypes.add(t2);
        }
        HashMap<Object, Integer> typeToInt = new HashMap<Object, Integer>();
        int nextint = 1;
        Iterator it = declaredTypes.iterator();
        while (it.hasNext()) {
            typeToInt.put(it.next(), new Integer(nextint++));
        }
        Iterator tIt = actualTypes.iterator();
        while (tIt.hasNext()) {
            Type t3 = (Type)tIt.next();
            if (typeToInt.containsKey(t3)) continue;
            typeToInt.put(t3, new Integer(nextint++));
        }
        file.println("Declared Types:");
        Iterator declTypeIt = declaredTypes.iterator();
        while (declTypeIt.hasNext()) {
            Type declType = (Type)declTypeIt.next();
            Iterator actTypeIt = actualTypes.iterator();
            while (actTypeIt.hasNext()) {
                Type actType = (Type)actTypeIt.next();
                if (!this.pag.getTypeManager().castNeverFails(actType, declType)) continue;
                file.println("" + typeToInt.get(declType) + " " + typeToInt.get(actType));
            }
        }
        file.println("Allocation Types:");
        Numberer.NumbererIterator nIt2 = this.pag.allocSources().iterator();
        while (nIt2.hasNext()) {
            n = (Node)nIt2.next();
            if (n.getReplacement() != n) continue;
            t = n.getType();
            this.dumpNode(n, file);
            if (t == null) {
                throw new RuntimeException("allocnode with null type");
            }
            file.println(" " + typeToInt.get(t));
        }
        file.println("Variable Types:");
        nIt2 = this.pag.getVarNodeNumberer().iterator();
        while (nIt2.hasNext()) {
            n = (Node)nIt2.next();
            if (n.getReplacement() != n) continue;
            t = n.getType();
            this.dumpNode(n, file);
            if (t == null) {
                file.println(" 0");
                continue;
            }
            file.println(" " + typeToInt.get(t));
        }
    }

    protected int fieldToNum(SparkField f) {
        Integer ret = (Integer)this.fieldMap.get(f);
        if (ret == null) {
            ret = new Integer(++this.fieldNum);
            this.fieldMap.put(f, ret);
        }
        return ret;
    }

    protected void dumpNode(Node n, PrintWriter out) throws IOException {
        if (n.getReplacement() != n) {
            throw new RuntimeException("Attempt to dump collapsed node.");
        }
        if (n instanceof FieldRefNode) {
            FieldRefNode fn = (FieldRefNode)n;
            this.dumpNode(fn.getBase(), out);
            out.print(" " + this.fieldToNum(fn.getField()));
        } else if (this.pag.getOpts().class_method_var() && n instanceof VarNode) {
            VarNode vn = (VarNode)n;
            SootMethod m = null;
            if (vn instanceof LocalVarNode) {
                m = ((LocalVarNode)vn).getMethod();
            }
            SootClass c = null;
            if (m != null) {
                c = m.getDeclaringClass();
            }
            ObjectNumberer cl = this.root.findOrAdd(c);
            ObjectNumberer me = cl.findOrAdd(m);
            ObjectNumberer vr = me.findOrAdd(vn);
            out.print("" + cl.num + " " + me.num + " " + vr.num);
        } else if (this.pag.getOpts().topo_sort() && n instanceof VarNode) {
            out.print("" + ((VarNode)n).finishingNumber);
        } else {
            out.print("" + n.getNumber());
        }
    }

    class ObjectNumberer {
        Object o = null;
        int num = 0;
        int nextChildNum = 1;
        HashMap children = null;

        ObjectNumberer(Object o, int num) {
            this.o = o;
            this.num = num;
        }

        ObjectNumberer findOrAdd(Object child) {
            ObjectNumberer ret;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((ret = (ObjectNumberer)this.children.get(child)) == null) {
                ret = new ObjectNumberer(child, this.nextChildNum++);
                this.children.put(child, ret);
            }
            return ret;
        }
    }
}

