/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.internal;

import soot.Scene;
import soot.Type;
import soot.jimple.spark.internal.AbstractTypeManager;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.BDDPAG;
import soot.jimple.spark.pag.VarNode;
import soot.relations.Domain;
import soot.relations.PhysicalDomain;
import soot.relations.Relation;
import soot.util.Numberer;

public final class BDDTypeManager
extends AbstractTypeManager {
    int lastAllocNode = 0;
    int lastVarNode = 0;
    private final PhysicalDomain t1;
    private final PhysicalDomain t2;
    private final PhysicalDomain v1;
    private final PhysicalDomain h1;
    private final Domain subt;
    private final Domain supt;
    private final Domain type;
    private final Domain var;
    private final Domain obj;
    private final Relation typeSubtype;
    private final Relation varNodeType;
    private final Relation newVnType;
    private final Relation allocNodeType;
    private final Relation newAnType;
    private final Relation typeMask;

    public BDDTypeManager(BDDPAG bddpag) {
        super(bddpag);
        this.t1 = ((BDDPAG)this.pag).t1;
        this.t2 = ((BDDPAG)this.pag).t2;
        this.v1 = ((BDDPAG)this.pag).v1;
        this.h1 = ((BDDPAG)this.pag).h1;
        this.subt = new Domain(Scene.v().getTypeNumberer(), "subt");
        this.supt = new Domain(Scene.v().getTypeNumberer(), "supt");
        this.type = new Domain(Scene.v().getTypeNumberer(), "type");
        this.var = ((BDDPAG)this.pag).var;
        this.obj = ((BDDPAG)this.pag).obj;
        this.typeSubtype = new Relation(this.subt, this.supt, this.t1, this.t2);
        this.varNodeType = new Relation(this.var, this.type, this.v1, this.t1);
        this.newVnType = this.varNodeType.sameDomains();
        this.allocNodeType = new Relation(this.obj, this.type, this.h1, this.t1);
        this.newAnType = this.allocNodeType.sameDomains();
        this.typeMask = new Relation(this.var, this.obj, this.v1, this.h1);
    }

    public final void clearTypeMask() {
        this.lastAllocNode = 0;
        this.lastVarNode = 0;
        this.typeMask.makeEmpty();
        this.varNodeType.makeEmpty();
        this.allocNodeType.makeEmpty();
        this.typeSubtype.makeEmpty();
    }

    public final void makeTypeMask() {
        if (this.fh == null) {
            this.typeMask.makeFull();
        }
        this.update();
    }

    public final Relation get() {
        this.update();
        return this.typeMask;
    }

    private void update() {
        int j;
        int i;
        if (this.fh == null) {
            return;
        }
        Numberer anNumb = this.pag.getAllocNodeNumberer();
        Numberer vnNumb = this.pag.getVarNodeNumberer();
        for (i = 1; i <= vnNumb.size(); ++i) {
            for (j = this.lastAllocNode + 1; j <= anNumb.size(); ++j) {
                this.updatePair((VarNode)vnNumb.get(i), (AllocNode)anNumb.get(j));
            }
        }
        for (i = this.lastVarNode + 1; i <= vnNumb.size(); ++i) {
            for (j = 1; j <= this.lastAllocNode; ++j) {
                this.updatePair((VarNode)vnNumb.get(i), (AllocNode)anNumb.get(j));
            }
        }
        this.varNodeType.eqUnion(this.varNodeType, this.newVnType);
        this.allocNodeType.eqUnion(this.allocNodeType, this.newAnType);
        Relation tmp = new Relation(this.var, this.subt, this.v1, this.t1);
        Relation tmp2 = new Relation(this.var, this.obj, this.v1, this.h1);
        tmp.eqRelprod(this.typeSubtype, this.supt, this.newVnType, this.type, this.var, this.newVnType, this.var, this.subt, this.typeSubtype, this.subt);
        tmp2.eqRelprod(this.allocNodeType, this.type, tmp, this.subt, this.var, tmp, this.var, this.obj, this.allocNodeType, this.obj);
        this.typeMask.eqUnion(this.typeMask, tmp2);
        tmp.eqRelprod(this.typeSubtype, this.supt, this.varNodeType, this.type, this.var, this.varNodeType, this.var, this.subt, this.typeSubtype, this.subt);
        tmp2.eqRelprod(this.newAnType, this.type, tmp, this.subt, this.var, tmp, this.var, this.obj, this.newAnType, this.obj);
        this.typeMask.eqUnion(this.typeMask, tmp2);
        this.newVnType.makeEmpty();
        this.newAnType.makeEmpty();
        this.lastAllocNode = anNumb.size();
        this.lastVarNode = vnNumb.size();
        tmp.makeEmpty();
        tmp2.makeEmpty();
    }

    private void updatePair(VarNode vn, AllocNode an) {
        Type vtype = vn.getType();
        Type atype = an.getType();
        if ((this.varNodeType.restrict(this.type, vtype).isEmpty() || this.allocNodeType.restrict(this.type, atype).isEmpty()) && this.castNeverFails(atype, vtype)) {
            this.typeSubtype.add(this.subt, atype, this.supt, vtype);
        }
        this.newVnType.add(this.var, vn, this.type, vtype);
        this.newAnType.add(this.obj, an, this.type, atype);
    }
}

