/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.builder;

import soot.ArrayType;
import soot.Local;
import soot.PointsToAnalysis;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.spark.pag.AbstractMethodPAG;
import soot.jimple.spark.pag.AbstractPAG;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.Parm;
import soot.jimple.spark.pag.VarNode;
import soot.toolkits.scalar.Pair;

public class MethodNodeFactory
extends AbstractJimpleValueSwitch {
    protected AbstractPAG pag;
    protected AbstractMethodPAG mpag;
    protected SootMethod method;

    public MethodNodeFactory(AbstractPAG pag, AbstractMethodPAG mpag) {
        this.pag = pag;
        this.mpag = mpag;
        this.setCurrentMethod(mpag.getMethod());
    }

    private void setCurrentMethod(SootMethod m) {
        this.method = m;
        if (!m.isStatic()) {
            SootClass c = m.getDeclaringClass();
            if (c == null) {
                throw new RuntimeException("Method " + m + " has no declaring lass");
            }
            this.caseThis();
        }
        for (int i = 0; i < m.getParameterCount(); ++i) {
            if (!(m.getParameterType(i) instanceof RefLikeType)) continue;
            this.caseParm(i);
        }
        Type retType = m.getReturnType();
        if (retType instanceof RefLikeType) {
            this.caseRet();
        }
    }

    public Node getNode(Value v) {
        v.apply(this);
        return this.getNode();
    }

    public final void handleStmt(Stmt s) {
        if (s.containsInvokeExpr()) {
            return;
        }
        s.apply(new AbstractStmtSwitch(){

            public final void caseAssignStmt(AssignStmt as) {
                Value l = as.getLeftOp();
                Value r = as.getRightOp();
                if (!(l.getType() instanceof RefLikeType)) {
                    return;
                }
                l.apply(MethodNodeFactory.this);
                Node dest = MethodNodeFactory.this.getNode();
                r.apply(MethodNodeFactory.this);
                Node src = MethodNodeFactory.this.getNode();
                if (l instanceof InstanceFieldRef) {
                    ((InstanceFieldRef)l).getBase().apply(MethodNodeFactory.this);
                    MethodNodeFactory.this.pag.addDereference((VarNode)MethodNodeFactory.this.getNode());
                }
                if (r instanceof InstanceFieldRef) {
                    ((InstanceFieldRef)r).getBase().apply(MethodNodeFactory.this);
                    MethodNodeFactory.this.pag.addDereference((VarNode)MethodNodeFactory.this.getNode());
                }
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            public final void caseReturnStmt(ReturnStmt rs) {
                if (!(rs.getOp().getType() instanceof RefLikeType)) {
                    return;
                }
                rs.getOp().apply(MethodNodeFactory.this);
                Node retNode = MethodNodeFactory.this.getNode();
                MethodNodeFactory.this.mpag.addInternalEdge(retNode, MethodNodeFactory.this.caseRet());
            }

            public final void caseIdentityStmt(IdentityStmt is) {
                if (!(is.getLeftOp().getType() instanceof RefLikeType)) {
                    return;
                }
                is.getLeftOp().apply(MethodNodeFactory.this);
                Node dest = MethodNodeFactory.this.getNode();
                is.getRightOp().apply(MethodNodeFactory.this);
                Node src = MethodNodeFactory.this.getNode();
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            public final void caseThrowStmt(ThrowStmt ts) {
                ts.getOp().apply(MethodNodeFactory.this);
                MethodNodeFactory.this.mpag.addOutEdge(MethodNodeFactory.this.getNode(), MethodNodeFactory.this.pag.nodeFactory().caseThrow());
            }
        });
    }

    public final Node getNode() {
        return (Node)this.getResult();
    }

    public final Node caseThis() {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Pair(this.method, PointsToAnalysis.THIS_NODE), this.method.getDeclaringClass().getType(), this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public final Node caseParm(int index) {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Pair(this.method, new Integer(index)), this.method.getParameterType(index), this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public final Node caseRet() {
        LocalVarNode ret = this.pag.makeLocalVarNode(Parm.v(this.method, -2), this.method.getReturnType(), this.method);
        ret.setInterProcSource();
        return ret;
    }

    public final Node caseArray(VarNode base) {
        return this.pag.makeFieldRefNode(base, ArrayElement.v());
    }

    public final void caseArrayRef(ArrayRef ar) {
        this.caseLocal((Local)ar.getBase());
        this.setResult(this.caseArray((VarNode)this.getNode()));
    }

    public final void caseCastExpr(CastExpr ce) {
        Pair castPair = new Pair(ce, PointsToAnalysis.CAST_NODE);
        ce.getOp().apply(this);
        Node opNode = this.getNode();
        LocalVarNode castNode = this.pag.makeLocalVarNode(castPair, ce.getCastType(), this.method);
        this.mpag.addInternalEdge(opNode, castNode);
        this.setResult(castNode);
    }

    public final void caseCaughtExceptionRef(CaughtExceptionRef cer) {
        this.setResult(this.pag.nodeFactory().caseThrow());
    }

    public final void caseInstanceFieldRef(InstanceFieldRef ifr) {
        if (this.pag.getOpts().field_based() || this.pag.getOpts().vta()) {
            this.setResult(this.pag.makeGlobalVarNode(ifr.getField(), ifr.getField().getType()));
        } else {
            this.setResult(this.pag.makeLocalFieldRefNode(ifr.getBase(), ifr.getBase().getType(), ifr.getField(), this.method));
        }
    }

    public final void caseLocal(Local l) {
        this.setResult(this.pag.makeLocalVarNode(l, l.getType(), this.method));
    }

    public final void caseNewArrayExpr(NewArrayExpr nae) {
        this.setResult(this.pag.makeAllocNode(nae, nae.getType(), this.method));
    }

    public final void caseNewExpr(NewExpr ne) {
        if (this.pag.getOpts().merge_stringbuffer() && ne.getType().equals(RefType.v("java.lang.StringBuffer"))) {
            this.setResult(this.pag.makeAllocNode(ne.getType(), ne.getType(), null));
        } else {
            this.setResult(this.pag.makeAllocNode(ne, ne.getType(), this.method));
        }
    }

    public final void caseNewMultiArrayExpr(NewMultiArrayExpr nmae) {
        Type t;
        ArrayType type = (ArrayType)nmae.getType();
        AllocNode prevAn = this.pag.makeAllocNode(new Pair(nmae, new Integer(type.numDimensions)), type, this.method);
        LocalVarNode prevVn = this.pag.makeLocalVarNode(prevAn, prevAn.getType(), null);
        this.mpag.addInternalEdge(prevAn, prevVn);
        this.setResult(prevAn);
        while ((t = type.getElementType()) instanceof ArrayType) {
            type = (ArrayType)t;
            AllocNode an = this.pag.makeAllocNode(new Pair(nmae, new Integer(type.numDimensions)), type, this.method);
            LocalVarNode vn = this.pag.makeLocalVarNode(an, an.getType(), null);
            this.mpag.addInternalEdge(an, vn);
            this.mpag.addInternalEdge(vn, this.pag.makeFieldRefNode(prevVn, ArrayElement.v()));
            prevAn = an;
            prevVn = vn;
        }
    }

    public final void caseParameterRef(ParameterRef pr) {
        this.setResult(this.caseParm(pr.getIndex()));
    }

    public final void caseStaticFieldRef(StaticFieldRef sfr) {
        this.setResult(this.pag.makeGlobalVarNode(sfr.getField(), sfr.getField().getType()));
    }

    public final void caseStringConstant(StringConstant sc) {
        AllocNode stringConstant = this.pag.getOpts().string_constants() || Scene.v().containsClass(sc.value) || sc.value.length() > 0 && sc.value.charAt(0) == '[' ? this.pag.makeStringConstantNode(sc.value) : this.pag.makeAllocNode(PointsToAnalysis.STRING_NODE, RefType.v("java.lang.String"), null);
        GlobalVarNode stringConstantLocal = this.pag.makeGlobalVarNode(stringConstant, RefType.v("java.lang.String"));
        this.mpag.addInEdge(stringConstant, stringConstantLocal);
        this.setResult(stringConstantLocal);
    }

    public final void caseThisRef(ThisRef tr) {
        this.setResult(this.caseThis());
    }

    public final void caseNullConstant(NullConstant nr) {
        this.setResult(null);
    }

    public final void defaultCase(Object v) {
        throw new RuntimeException("failed to handle " + v);
    }
}

