/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.builder;

import soot.AnySubType;
import soot.ArrayType;
import soot.PointsToAnalysis;
import soot.RefType;
import soot.jimple.spark.pag.AbstractPAG;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.VarNode;

public class GlobalNodeFactory {
    protected AbstractPAG pag;

    public GlobalNodeFactory(AbstractPAG pag) {
        this.pag = pag;
    }

    public final Node caseDefaultClassLoader() {
        AllocNode a = this.pag.makeAllocNode(PointsToAnalysis.DEFAULT_CLASS_LOADER, AnySubType.v(RefType.v("java.lang.ClassLoader")), null);
        GlobalVarNode v = this.pag.makeGlobalVarNode(PointsToAnalysis.DEFAULT_CLASS_LOADER_LOCAL, RefType.v("java.lang.ClassLoader"));
        this.pag.addEdge(a, v);
        return v;
    }

    public final Node caseMainClassNameString() {
        AllocNode a = this.pag.makeAllocNode(PointsToAnalysis.MAIN_CLASS_NAME_STRING, RefType.v("java.lang.String"), null);
        GlobalVarNode v = this.pag.makeGlobalVarNode(PointsToAnalysis.MAIN_CLASS_NAME_STRING_LOCAL, RefType.v("java.lang.String"));
        this.pag.addEdge(a, v);
        return v;
    }

    public final Node caseMainThreadGroup() {
        AllocNode threadGroupNode = this.pag.makeAllocNode(PointsToAnalysis.MAIN_THREAD_GROUP_NODE, RefType.v("java.lang.ThreadGroup"), null);
        GlobalVarNode threadGroupNodeLocal = this.pag.makeGlobalVarNode(PointsToAnalysis.MAIN_THREAD_GROUP_NODE_LOCAL, RefType.v("java.lang.ThreadGroup"));
        this.pag.addEdge(threadGroupNode, threadGroupNodeLocal);
        return threadGroupNodeLocal;
    }

    public final Node caseMainThread() {
        AllocNode threadNode = this.pag.makeAllocNode(PointsToAnalysis.MAIN_THREAD_NODE, RefType.v("java.lang.Thread"), null);
        GlobalVarNode threadNodeLocal = this.pag.makeGlobalVarNode(PointsToAnalysis.MAIN_THREAD_NODE_LOCAL, RefType.v("java.lang.Thread"));
        this.pag.addEdge(threadNode, threadNodeLocal);
        return threadNodeLocal;
    }

    public final Node caseArgv() {
        AllocNode argv = this.pag.makeAllocNode(PointsToAnalysis.STRING_ARRAY_NODE, ArrayType.v(RefType.v("java.lang.String"), 1), null);
        GlobalVarNode sanl = this.pag.makeGlobalVarNode(PointsToAnalysis.STRING_ARRAY_NODE_LOCAL, ArrayType.v(RefType.v("java.lang.String"), 1));
        AllocNode stringNode = this.pag.makeAllocNode(PointsToAnalysis.STRING_NODE, RefType.v("java.lang.String"), null);
        GlobalVarNode stringNodeLocal = this.pag.makeGlobalVarNode(PointsToAnalysis.STRING_NODE_LOCAL, RefType.v("java.lang.String"));
        this.pag.addEdge(argv, sanl);
        this.pag.addEdge(stringNode, stringNodeLocal);
        this.pag.addEdge(stringNodeLocal, this.pag.makeFieldRefNode(sanl, ArrayElement.v()));
        return sanl;
    }

    public final Node caseNewInstance(VarNode cls) {
        if (cls instanceof ContextVarNode) {
            cls = this.pag.findLocalVarNode(cls.getVariable());
        }
        AllocNode site = this.pag.makeAllocNode(cls, AnySubType.v(RefType.v("java.lang.Object")), null);
        GlobalVarNode local = this.pag.makeGlobalVarNode(site, RefType.v("java.lang.Object"));
        this.pag.addEdge(site, local);
        return local;
    }

    protected Node caseThrow() {
        GlobalVarNode ret = this.pag.makeGlobalVarNode(PointsToAnalysis.EXCEPTION_NODE, RefType.v("java.lang.Throwable"));
        ret.setInterProcTarget();
        ret.setInterProcSource();
        return ret;
    }
}

