/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.ReachingTypeDumper;
import soot.jimple.Stmt;
import soot.jimple.spark.AbstractSparkTransformer;
import soot.jimple.spark.builder.ContextInsensitiveBuilder;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.PAG2HTML;
import soot.jimple.spark.pag.PAGDumper;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.EBBCollapser;
import soot.jimple.spark.solver.PropAlias;
import soot.jimple.spark.solver.PropCycle;
import soot.jimple.spark.solver.PropIter;
import soot.jimple.spark.solver.PropMerge;
import soot.jimple.spark.solver.PropWorklist;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.SCCCollapser;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.options.SparkOptions;
import soot.tagkit.StringTag;
import soot.util.SourceLocator;

public class SparkTransformer
extends AbstractSparkTransformer {
    public SparkTransformer(Singletons.Global g) {
    }

    public static SparkTransformer v() {
        return G.v().SparkTransformer();
    }

    protected void internalTransform(String phaseName, Map options) {
        SparkOptions opts = new SparkOptions(options);
        String output_dir = SourceLocator.v().getOutputDir();
        ContextInsensitiveBuilder b = new ContextInsensitiveBuilder();
        if (opts.pre_jimplify()) {
            b.preJimplify();
        }
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        Date startBuild = new Date();
        PAG pag = (PAG)b.setup(opts);
        b.build();
        Date endBuild = new Date();
        SparkTransformer.reportTime("Pointer Assignment Graph", startBuild, endBuild);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        Date startTM = new Date();
        pag.getTypeManager().makeTypeMask();
        Date endTM = new Date();
        SparkTransformer.reportTime("Type masks", startTM, endTM);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        if (opts.verbose()) {
            G.v().out.println("VarNodes: " + pag.getVarNodeNumberer().size());
            G.v().out.println("FieldRefNodes: " + pag.getFieldRefNodeNumberer().size());
            G.v().out.println("AllocNodes: " + pag.getAllocNodeNumberer().size());
        }
        Date startSimplify = new Date();
        if (opts.simplify_sccs() && !opts.on_fly_cg() || opts.vta()) {
            new SCCCollapser(pag, opts.ignore_types_for_sccs()).collapse();
        }
        if (opts.simplify_offline() && !opts.on_fly_cg()) {
            new EBBCollapser(pag).collapse();
        }
        pag.cleanUpMerges();
        Date endSimplify = new Date();
        SparkTransformer.reportTime("Pointer Graph simplified", startSimplify, endSimplify);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        PAGDumper dumper = null;
        if (opts.dump_pag() || opts.dump_solution()) {
            dumper = new PAGDumper(pag, output_dir);
        }
        if (opts.dump_pag()) {
            dumper.dump();
        }
        Date startProp = new Date();
        Propagator[] propagator = new Propagator[1];
        switch (opts.propagator()) {
            case 1: {
                propagator[0] = new PropIter(pag);
                break;
            }
            case 2: {
                propagator[0] = new PropWorklist(pag);
                break;
            }
            case 3: {
                propagator[0] = new PropCycle(pag);
                break;
            }
            case 4: {
                propagator[0] = new PropMerge(pag);
                break;
            }
            case 5: {
                propagator[0] = new PropAlias(pag);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (propagator[0] != null) {
            propagator[0].propagate();
        }
        Date endProp = new Date();
        SparkTransformer.reportTime("Propagation", startProp, endProp);
        SparkTransformer.reportTime("Solution found", startSimplify, endProp);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        if (!opts.on_fly_cg() || opts.vta()) {
            CallGraphBuilder cgb = new CallGraphBuilder(pag);
            cgb.build();
        }
        if (opts.verbose()) {
            G.v().out.println("[Spark] Number of reachable methods: " + Scene.v().getReachableMethods().size());
        }
        if (opts.set_mass()) {
            this.findSetMass(pag);
        }
        if (opts.dump_answer()) {
            new ReachingTypeDumper(pag, output_dir).dump();
        }
        if (opts.dump_solution()) {
            dumper.dumpPointsToSets();
        }
        if (opts.dump_html()) {
            new PAG2HTML(pag, output_dir).dump();
        }
        Scene.v().setPointsToAnalysis(pag);
        if (opts.add_tags()) {
            this.addTags(pag);
        }
    }

    protected void addTags(PAG pag) {
        final StringTag unknown = new StringTag("Untagged Spark node");
        final Map nodeToTag = pag.getNodeTags();
        Iterator cIt = Scene.v().getClasses().iterator();
        while (cIt.hasNext()) {
            SootClass c = (SootClass)cIt.next();
            Iterator mIt = c.methodIterator();
            while (mIt.hasNext()) {
                SootMethod m = (SootMethod)mIt.next();
                if (!m.isConcrete() || !m.hasActiveBody()) continue;
                Iterator sIt = m.getActiveBody().getUnits().iterator();
                while (sIt.hasNext()) {
                    int i;
                    final Stmt s = (Stmt)sIt.next();
                    if (!(s instanceof DefinitionStmt)) continue;
                    Value lhs = ((DefinitionStmt)s).getLeftOp();
                    VarNode v = null;
                    if (lhs instanceof Local) {
                        v = pag.findLocalVarNode((Local)lhs);
                    } else if (lhs instanceof FieldRef) {
                        v = pag.findGlobalVarNode(((FieldRef)lhs).getField());
                    }
                    if (v == null) continue;
                    PointsToSetInternal p2set = v.getP2Set();
                    p2set.forall(new P2SetVisitor(){

                        public final void visit(Node n) {
                            SparkTransformer.this.addTag(s, n, nodeToTag, unknown);
                        }
                    });
                    Node[] simpleSources = pag.simpleInvLookup(v);
                    for (i = 0; i < simpleSources.length; ++i) {
                        this.addTag(s, simpleSources[i], nodeToTag, unknown);
                    }
                    simpleSources = pag.allocInvLookup(v);
                    for (i = 0; i < simpleSources.length; ++i) {
                        this.addTag(s, simpleSources[i], nodeToTag, unknown);
                    }
                    simpleSources = pag.loadInvLookup(v);
                    for (i = 0; i < simpleSources.length; ++i) {
                        this.addTag(s, simpleSources[i], nodeToTag, unknown);
                    }
                }
            }
        }
    }
}

