/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.jimple.JimpleBody;
import soot.jimple.parser.Walker;
import soot.jimple.parser.node.AFieldMember;
import soot.jimple.parser.node.AFile;
import soot.jimple.parser.node.AFullMethodBody;
import soot.jimple.parser.node.AMethodMember;
import soot.jimple.parser.node.PModifier;
import soot.options.Options;

public class BodyExtractorWalker
extends Walker {
    Map methodToParsedBodyMap;

    public BodyExtractorWalker(SootClass sc, SootResolver resolver, Map methodToParsedBodyMap) {
        super(sc, resolver);
        this.methodToParsedBodyMap = methodToParsedBodyMap;
    }

    public void caseAFile(AFile node) {
        String className;
        this.inAFile(node);
        Object[] temp = node.getModifier().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PModifier)temp[i]).apply(this);
        }
        if (node.getFileType() != null) {
            node.getFileType().apply(this);
        }
        if (node.getClassName() != null) {
            node.getClassName().apply(this);
        }
        if (!(className = (String)this.mProductions.removeLast()).equals(this.mSootClass.getName())) {
            throw new RuntimeException("expected:  " + className + ", but got: " + this.mSootClass.getName());
        }
        if (node.getExtendsClause() != null) {
            node.getExtendsClause().apply(this);
        }
        if (node.getImplementsClause() != null) {
            node.getImplementsClause().apply(this);
        }
        if (node.getFileBody() != null) {
            node.getFileBody().apply(this);
        }
        this.outAFile(node);
    }

    public void outAFile(AFile node) {
        if (node.getImplementsClause() != null) {
            this.mProductions.removeLast();
        }
        if (node.getExtendsClause() != null) {
            this.mProductions.removeLast();
        }
        this.mProductions.removeLast();
        this.mProductions.addLast(this.mSootClass);
    }

    public void outAFieldMember(AFieldMember node) {
        this.mProductions.removeLast();
        this.mProductions.removeLast();
    }

    public void outAMethodMember(AMethodMember node) {
        boolean modifier = false;
        List parameterList = new ArrayList();
        List throwsClause = null;
        JimpleBody methodBody = null;
        if (node.getMethodBody() instanceof AFullMethodBody) {
            methodBody = (JimpleBody)this.mProductions.removeLast();
        }
        if (node.getThrowsClause() != null) {
            throwsClause = (List)this.mProductions.removeLast();
        }
        if (node.getParameterList() != null) {
            parameterList = (List)this.mProductions.removeLast();
        }
        String name = (String)this.mProductions.removeLast();
        Type type = (Type)this.mProductions.removeLast();
        SootMethod sm = null;
        if (this.mSootClass.declaresMethod(SootMethod.getSubSignature(name, parameterList, type))) {
            sm = this.mSootClass.getMethod(SootMethod.getSubSignature(name, parameterList, type));
            if (Options.v().verbose()) {
                G.v().out.println("[Jimple parser] " + SootMethod.getSubSignature(name, parameterList, type));
            }
        } else {
            G.v().out.println("[!!! Couldn't parse !!] " + SootMethod.getSubSignature(name, parameterList, type));
            G.v().out.println("[!] Methods in class are:");
            Iterator it = this.mSootClass.methodIterator();
            while (it.hasNext()) {
                SootMethod next = (SootMethod)it.next();
                G.v().out.println(next.getSubSignature());
            }
        }
        if (sm.isConcrete()) {
            if (Options.v().verbose()) {
                G.v().out.println("[Parsed] " + sm.getDeclaration());
            }
            methodBody.setMethod(sm);
            this.methodToParsedBodyMap.put(sm, methodBody);
        } else if (node.getMethodBody() instanceof AFullMethodBody) {
            if (sm.isPhantom() && Options.v().verbose()) {
                G.v().out.println("[jimple parser] phantom method!");
            }
            throw new RuntimeException("Impossible: !concrete => ! instanceof " + sm.getName());
        }
    }
}

